/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for Permissions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Permissions extends com.google.api.client.json.GenericJson {

  /**
   * ID of the issuer the list of permissions refer to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long issuerId;

  /**
   * The complete list of permissions for the issuer account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Permission> permissions;

  static {
    // hack to force ProGuard to consider Permission used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Permission.class);
  }

  /**
   * ID of the issuer the list of permissions refer to.
   * @return value or {@code null} for none
   */
  public java.lang.Long getIssuerId() {
    return issuerId;
  }

  /**
   * ID of the issuer the list of permissions refer to.
   * @param issuerId issuerId or {@code null} for none
   */
  public Permissions setIssuerId(java.lang.Long issuerId) {
    this.issuerId = issuerId;
    return this;
  }

  /**
   * The complete list of permissions for the issuer account.
   * @return value or {@code null} for none
   */
  public java.util.List<Permission> getPermissions() {
    return permissions;
  }

  /**
   * The complete list of permissions for the issuer account.
   * @param permissions permissions or {@code null} for none
   */
  public Permissions setPermissions(java.util.List<Permission> permissions) {
    this.permissions = permissions;
    return this;
  }

  @Override
  public Permissions set(String fieldName, Object value) {
    return (Permissions) super.set(fieldName, value);
  }

  @Override
  public Permissions clone() {
    return (Permissions) super.clone();
  }

}
