/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for Pagination.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Pagination extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#pagination"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Page token to send to fetch the next page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Number of results returned in this page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer resultsPerPage;

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#pagination"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#pagination"`.
   * @param kind kind or {@code null} for none
   */
  public Pagination setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Page token to send to fetch the next page.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Page token to send to fetch the next page.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public Pagination setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Number of results returned in this page.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * Number of results returned in this page.
   * @param resultsPerPage resultsPerPage or {@code null} for none
   */
  public Pagination setResultsPerPage(java.lang.Integer resultsPerPage) {
    this.resultsPerPage = resultsPerPage;
    return this;
  }

  @Override
  public Pagination set(String fieldName, Object value) {
    return (Pagination) super.set(fieldName, value);
  }

  @Override
  public Pagination clone() {
    return (Pagination) super.clone();
  }

}
