/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * A message that will be displayed with a Valuable
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Message extends com.google.api.client.json.GenericJson {

  /**
   * The message body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String body;

  /**
   * The period of time that the message will be displayed to users. You can define both a
   * `startTime` and `endTime` for each message. A message is displayed immediately after a Wallet
   * Object is inserted unless a `startTime` is set. The message will appear in a list of messages
   * indefinitely if `endTime` is not provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeInterval displayInterval;

  /**
   * The message header.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String header;

  /**
   * The ID associated with a message. This field is here to enable ease of management of messages.
   * Notice ID values could possibly duplicate across multiple messages in the same class/instance,
   * and care must be taken to select a reasonable ID for each message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#walletObjectMessage"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Translated strings for the message body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedBody;

  /**
   * Translated strings for the message header.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedHeader;

  /**
   * The message type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String messageType;

  /**
   * The message body.
   * @return value or {@code null} for none
   */
  public java.lang.String getBody() {
    return body;
  }

  /**
   * The message body.
   * @param body body or {@code null} for none
   */
  public Message setBody(java.lang.String body) {
    this.body = body;
    return this;
  }

  /**
   * The period of time that the message will be displayed to users. You can define both a
   * `startTime` and `endTime` for each message. A message is displayed immediately after a Wallet
   * Object is inserted unless a `startTime` is set. The message will appear in a list of messages
   * indefinitely if `endTime` is not provided.
   * @return value or {@code null} for none
   */
  public TimeInterval getDisplayInterval() {
    return displayInterval;
  }

  /**
   * The period of time that the message will be displayed to users. You can define both a
   * `startTime` and `endTime` for each message. A message is displayed immediately after a Wallet
   * Object is inserted unless a `startTime` is set. The message will appear in a list of messages
   * indefinitely if `endTime` is not provided.
   * @param displayInterval displayInterval or {@code null} for none
   */
  public Message setDisplayInterval(TimeInterval displayInterval) {
    this.displayInterval = displayInterval;
    return this;
  }

  /**
   * The message header.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeader() {
    return header;
  }

  /**
   * The message header.
   * @param header header or {@code null} for none
   */
  public Message setHeader(java.lang.String header) {
    this.header = header;
    return this;
  }

  /**
   * The ID associated with a message. This field is here to enable ease of management of messages.
   * Notice ID values could possibly duplicate across multiple messages in the same class/instance,
   * and care must be taken to select a reasonable ID for each message.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID associated with a message. This field is here to enable ease of management of messages.
   * Notice ID values could possibly duplicate across multiple messages in the same class/instance,
   * and care must be taken to select a reasonable ID for each message.
   * @param id id or {@code null} for none
   */
  public Message setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#walletObjectMessage"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#walletObjectMessage"`.
   * @param kind kind or {@code null} for none
   */
  public Message setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Translated strings for the message body.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedBody() {
    return localizedBody;
  }

  /**
   * Translated strings for the message body.
   * @param localizedBody localizedBody or {@code null} for none
   */
  public Message setLocalizedBody(LocalizedString localizedBody) {
    this.localizedBody = localizedBody;
    return this;
  }

  /**
   * Translated strings for the message header.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedHeader() {
    return localizedHeader;
  }

  /**
   * Translated strings for the message header.
   * @param localizedHeader localizedHeader or {@code null} for none
   */
  public Message setLocalizedHeader(LocalizedString localizedHeader) {
    this.localizedHeader = localizedHeader;
    return this;
  }

  /**
   * The message type.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessageType() {
    return messageType;
  }

  /**
   * The message type.
   * @param messageType messageType or {@code null} for none
   */
  public Message setMessageType(java.lang.String messageType) {
    this.messageType = messageType;
    return this;
  }

  @Override
  public Message set(String fieldName, Object value) {
    return (Message) super.set(fieldName, value);
  }

  @Override
  public Message clone() {
    return (Message) super.clone();
  }

}
