/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for ListTemplateOverride.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListTemplateOverride extends com.google.api.client.json.GenericJson {

  /**
   * Specifies from a predefined set of options or from a reference to the field what will be
   * displayed in the first row. To set this override, set the FirstRowOption.fieldOption to the
   * FieldSelector of your choice.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FirstRowOption firstRowOption;

  /**
   * A reference to the field to be displayed in the second row. This option is only displayed if
   * there are not multiple user objects in a group. If there is a group, the second row will always
   * display a field shared by all objects. To set this override, please set secondRowOption to the
   * FieldSelector of you choice.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldSelector secondRowOption;

  /**
   * An unused/deprecated field. Setting it will have no effect on what the user sees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldSelector thirdRowOption;

  /**
   * Specifies from a predefined set of options or from a reference to the field what will be
   * displayed in the first row. To set this override, set the FirstRowOption.fieldOption to the
   * FieldSelector of your choice.
   * @return value or {@code null} for none
   */
  public FirstRowOption getFirstRowOption() {
    return firstRowOption;
  }

  /**
   * Specifies from a predefined set of options or from a reference to the field what will be
   * displayed in the first row. To set this override, set the FirstRowOption.fieldOption to the
   * FieldSelector of your choice.
   * @param firstRowOption firstRowOption or {@code null} for none
   */
  public ListTemplateOverride setFirstRowOption(FirstRowOption firstRowOption) {
    this.firstRowOption = firstRowOption;
    return this;
  }

  /**
   * A reference to the field to be displayed in the second row. This option is only displayed if
   * there are not multiple user objects in a group. If there is a group, the second row will always
   * display a field shared by all objects. To set this override, please set secondRowOption to the
   * FieldSelector of you choice.
   * @return value or {@code null} for none
   */
  public FieldSelector getSecondRowOption() {
    return secondRowOption;
  }

  /**
   * A reference to the field to be displayed in the second row. This option is only displayed if
   * there are not multiple user objects in a group. If there is a group, the second row will always
   * display a field shared by all objects. To set this override, please set secondRowOption to the
   * FieldSelector of you choice.
   * @param secondRowOption secondRowOption or {@code null} for none
   */
  public ListTemplateOverride setSecondRowOption(FieldSelector secondRowOption) {
    this.secondRowOption = secondRowOption;
    return this;
  }

  /**
   * An unused/deprecated field. Setting it will have no effect on what the user sees.
   * @return value or {@code null} for none
   */
  public FieldSelector getThirdRowOption() {
    return thirdRowOption;
  }

  /**
   * An unused/deprecated field. Setting it will have no effect on what the user sees.
   * @param thirdRowOption thirdRowOption or {@code null} for none
   */
  public ListTemplateOverride setThirdRowOption(FieldSelector thirdRowOption) {
    this.thirdRowOption = thirdRowOption;
    return this;
  }

  @Override
  public ListTemplateOverride set(String fieldName, Object value) {
    return (ListTemplateOverride) super.set(fieldName, value);
  }

  @Override
  public ListTemplateOverride clone() {
    return (ListTemplateOverride) super.clone();
  }

}
