/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * A pair of text strings to be displayed in the details view. Note we no longer display
 * LabelValue/LabelValueRow as a table, instead a list of items.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LabelValue extends com.google.api.client.json.GenericJson {

  /**
   * The label for a specific row and column. Recommended maximum is 15 characters for a two-column
   * layout and 30 characters for a one-column layout.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * Translated strings for the label. Recommended maximum is 15 characters for a two-column layout
   * and 30 characters for a one-column layout.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedLabel;

  /**
   * Translated strings for the value. Recommended maximum is 15 characters for a two-column layout
   * and 30 characters for a one-column layout.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedValue;

  /**
   * The value for a specific row and column. Recommended maximum is 15 characters for a two-column
   * layout and 30 characters for a one-column layout.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The label for a specific row and column. Recommended maximum is 15 characters for a two-column
   * layout and 30 characters for a one-column layout.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * The label for a specific row and column. Recommended maximum is 15 characters for a two-column
   * layout and 30 characters for a one-column layout.
   * @param label label or {@code null} for none
   */
  public LabelValue setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * Translated strings for the label. Recommended maximum is 15 characters for a two-column layout
   * and 30 characters for a one-column layout.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedLabel() {
    return localizedLabel;
  }

  /**
   * Translated strings for the label. Recommended maximum is 15 characters for a two-column layout
   * and 30 characters for a one-column layout.
   * @param localizedLabel localizedLabel or {@code null} for none
   */
  public LabelValue setLocalizedLabel(LocalizedString localizedLabel) {
    this.localizedLabel = localizedLabel;
    return this;
  }

  /**
   * Translated strings for the value. Recommended maximum is 15 characters for a two-column layout
   * and 30 characters for a one-column layout.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedValue() {
    return localizedValue;
  }

  /**
   * Translated strings for the value. Recommended maximum is 15 characters for a two-column layout
   * and 30 characters for a one-column layout.
   * @param localizedValue localizedValue or {@code null} for none
   */
  public LabelValue setLocalizedValue(LocalizedString localizedValue) {
    this.localizedValue = localizedValue;
    return this;
  }

  /**
   * The value for a specific row and column. Recommended maximum is 15 characters for a two-column
   * layout and 30 characters for a one-column layout.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The value for a specific row and column. Recommended maximum is 15 characters for a two-column
   * layout and 30 characters for a one-column layout.
   * @param value value or {@code null} for none
   */
  public LabelValue setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public LabelValue set(String fieldName, Object value) {
    return (LabelValue) super.set(fieldName, value);
  }

  @Override
  public LabelValue clone() {
    return (LabelValue) super.clone();
  }

}
