/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for IssuerContactInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IssuerContactInfo extends com.google.api.client.json.GenericJson {

  /**
   * Email addresses which will receive alerts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> alertsEmails;

  /**
   * The primary contact email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * The primary contact name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The primary contact phone number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phone;

  /**
   * Email addresses which will receive alerts.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAlertsEmails() {
    return alertsEmails;
  }

  /**
   * Email addresses which will receive alerts.
   * @param alertsEmails alertsEmails or {@code null} for none
   */
  public IssuerContactInfo setAlertsEmails(java.util.List<java.lang.String> alertsEmails) {
    this.alertsEmails = alertsEmails;
    return this;
  }

  /**
   * The primary contact email address.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The primary contact email address.
   * @param email email or {@code null} for none
   */
  public IssuerContactInfo setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * The primary contact name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The primary contact name.
   * @param name name or {@code null} for none
   */
  public IssuerContactInfo setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The primary contact phone number.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhone() {
    return phone;
  }

  /**
   * The primary contact phone number.
   * @param phone phone or {@code null} for none
   */
  public IssuerContactInfo setPhone(java.lang.String phone) {
    this.phone = phone;
    return this;
  }

  @Override
  public IssuerContactInfo set(String fieldName, Object value) {
    return (IssuerContactInfo) super.set(fieldName, value);
  }

  @Override
  public IssuerContactInfo clone() {
    return (IssuerContactInfo) super.clone();
  }

}
