/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for ImageUri.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ImageUri extends com.google.api.client.json.GenericJson {

  /**
   * Additional information about the image, which is unused and retained only for backward
   * compatibility.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Translated strings for the description, which are unused and retained only for backward
   * compatibility.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString localizedDescription;

  /**
   * The location of the image. URIs must have a scheme.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uri;

  /**
   * Additional information about the image, which is unused and retained only for backward
   * compatibility.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Additional information about the image, which is unused and retained only for backward
   * compatibility.
   * @param description description or {@code null} for none
   */
  public ImageUri setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Translated strings for the description, which are unused and retained only for backward
   * compatibility.
   * @return value or {@code null} for none
   */
  public LocalizedString getLocalizedDescription() {
    return localizedDescription;
  }

  /**
   * Translated strings for the description, which are unused and retained only for backward
   * compatibility.
   * @param localizedDescription localizedDescription or {@code null} for none
   */
  public ImageUri setLocalizedDescription(LocalizedString localizedDescription) {
    this.localizedDescription = localizedDescription;
    return this;
  }

  /**
   * The location of the image. URIs must have a scheme.
   * @return value or {@code null} for none
   */
  public java.lang.String getUri() {
    return uri;
  }

  /**
   * The location of the image. URIs must have a scheme.
   * @param uri uri or {@code null} for none
   */
  public ImageUri setUri(java.lang.String uri) {
    this.uri = uri;
    return this;
  }

  @Override
  public ImageUri set(String fieldName, Object value) {
    return (ImageUri) super.set(fieldName, value);
  }

  @Override
  public ImageUri clone() {
    return (ImageUri) super.clone();
  }

}
