/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for ImageModuleData.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ImageModuleData extends com.google.api.client.json.GenericJson {

  /**
   * The ID associated with an image module. This field is here to enable ease of management of
   * image modules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A 100% width image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image mainImage;

  /**
   * The ID associated with an image module. This field is here to enable ease of management of
   * image modules.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID associated with an image module. This field is here to enable ease of management of
   * image modules.
   * @param id id or {@code null} for none
   */
  public ImageModuleData setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A 100% width image.
   * @return value or {@code null} for none
   */
  public Image getMainImage() {
    return mainImage;
  }

  /**
   * A 100% width image.
   * @param mainImage mainImage or {@code null} for none
   */
  public ImageModuleData setMainImage(Image mainImage) {
    this.mainImage = mainImage;
    return this;
  }

  @Override
  public ImageModuleData set(String fieldName, Object value) {
    return (ImageModuleData) super.set(fieldName, value);
  }

  @Override
  public ImageModuleData clone() {
    return (ImageModuleData) super.clone();
  }

}
