/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for EventVenue.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventVenue extends com.google.api.client.json.GenericJson {

  /**
   * The address of the venue, such as "24 Willie Mays Plaza\nSan Francisco, CA 94107". Address
   * lines are separated by line feed (`\n`) characters. This is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString address;

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#eventVenue"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of the venue, such as "AT&T Park". This is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString name;

  /**
   * The address of the venue, such as "24 Willie Mays Plaza\nSan Francisco, CA 94107". Address
   * lines are separated by line feed (`\n`) characters. This is required.
   * @return value or {@code null} for none
   */
  public LocalizedString getAddress() {
    return address;
  }

  /**
   * The address of the venue, such as "24 Willie Mays Plaza\nSan Francisco, CA 94107". Address
   * lines are separated by line feed (`\n`) characters. This is required.
   * @param address address or {@code null} for none
   */
  public EventVenue setAddress(LocalizedString address) {
    this.address = address;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#eventVenue"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string `"walletobjects#eventVenue"`.
   * @param kind kind or {@code null} for none
   */
  public EventVenue setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of the venue, such as "AT&T Park". This is required.
   * @return value or {@code null} for none
   */
  public LocalizedString getName() {
    return name;
  }

  /**
   * The name of the venue, such as "AT&T Park". This is required.
   * @param name name or {@code null} for none
   */
  public EventVenue setName(LocalizedString name) {
    this.name = name;
    return this;
  }

  @Override
  public EventVenue set(String fieldName, Object value) {
    return (EventVenue) super.set(fieldName, value);
  }

  @Override
  public EventVenue clone() {
    return (EventVenue) super.clone();
  }

}
