/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for EventReservationInfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventReservationInfo extends com.google.api.client.json.GenericJson {

  /**
   * The confirmation code of the event reservation. This may also take the form of an "order
   * number", "confirmation number", "reservation number", or other equivalent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String confirmationCode;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#eventReservationInfo"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The confirmation code of the event reservation. This may also take the form of an "order
   * number", "confirmation number", "reservation number", or other equivalent.
   * @return value or {@code null} for none
   */
  public java.lang.String getConfirmationCode() {
    return confirmationCode;
  }

  /**
   * The confirmation code of the event reservation. This may also take the form of an "order
   * number", "confirmation number", "reservation number", or other equivalent.
   * @param confirmationCode confirmationCode or {@code null} for none
   */
  public EventReservationInfo setConfirmationCode(java.lang.String confirmationCode) {
    this.confirmationCode = confirmationCode;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#eventReservationInfo"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#eventReservationInfo"`.
   * @param kind kind or {@code null} for none
   */
  public EventReservationInfo setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public EventReservationInfo set(String fieldName, Object value) {
    return (EventReservationInfo) super.set(fieldName, value);
  }

  @Override
  public EventReservationInfo clone() {
    return (EventReservationInfo) super.clone();
  }

}
