/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Information about the merchant hosted signup flow for a program.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DiscoverableProgramMerchantSignupInfo extends com.google.api.client.json.GenericJson {

  /**
   * User data that is sent in a POST request to the signup website URL. This information is encoded
   * and then shared so that the merchant's website can prefill fields used to enroll the user for
   * the discoverable program.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> signupSharedDatas;

  /**
   * The URL to direct the user to for the merchant's signup site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Uri signupWebsite;

  /**
   * User data that is sent in a POST request to the signup website URL. This information is encoded
   * and then shared so that the merchant's website can prefill fields used to enroll the user for
   * the discoverable program.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSignupSharedDatas() {
    return signupSharedDatas;
  }

  /**
   * User data that is sent in a POST request to the signup website URL. This information is encoded
   * and then shared so that the merchant's website can prefill fields used to enroll the user for
   * the discoverable program.
   * @param signupSharedDatas signupSharedDatas or {@code null} for none
   */
  public DiscoverableProgramMerchantSignupInfo setSignupSharedDatas(java.util.List<java.lang.String> signupSharedDatas) {
    this.signupSharedDatas = signupSharedDatas;
    return this;
  }

  /**
   * The URL to direct the user to for the merchant's signup site.
   * @return value or {@code null} for none
   */
  public Uri getSignupWebsite() {
    return signupWebsite;
  }

  /**
   * The URL to direct the user to for the merchant's signup site.
   * @param signupWebsite signupWebsite or {@code null} for none
   */
  public DiscoverableProgramMerchantSignupInfo setSignupWebsite(Uri signupWebsite) {
    this.signupWebsite = signupWebsite;
    return this;
  }

  @Override
  public DiscoverableProgramMerchantSignupInfo set(String fieldName, Object value) {
    return (DiscoverableProgramMerchantSignupInfo) super.set(fieldName, value);
  }

  @Override
  public DiscoverableProgramMerchantSignupInfo clone() {
    return (DiscoverableProgramMerchantSignupInfo) super.clone();
  }

}
