/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Backend response for a Diff get version response. For details on the Scotty Diff protocol, visit
 * http://go/scotty-diff-protocol.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DiffVersionResponse extends com.google.api.client.json.GenericJson {

  /**
   * The total size of the server object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long objectSizeBytes;

  /**
   * The version of the object stored at the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectVersion;

  /**
   * The total size of the server object.
   * @return value or {@code null} for none
   */
  public java.lang.Long getObjectSizeBytes() {
    return objectSizeBytes;
  }

  /**
   * The total size of the server object.
   * @param objectSizeBytes objectSizeBytes or {@code null} for none
   */
  public DiffVersionResponse setObjectSizeBytes(java.lang.Long objectSizeBytes) {
    this.objectSizeBytes = objectSizeBytes;
    return this;
  }

  /**
   * The version of the object stored at the server.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectVersion() {
    return objectVersion;
  }

  /**
   * The version of the object stored at the server.
   * @param objectVersion objectVersion or {@code null} for none
   */
  public DiffVersionResponse setObjectVersion(java.lang.String objectVersion) {
    this.objectVersion = objectVersion;
    return this;
  }

  @Override
  public DiffVersionResponse set(String fieldName, Object value) {
    return (DiffVersionResponse) super.set(fieldName, value);
  }

  @Override
  public DiffVersionResponse clone() {
    return (DiffVersionResponse) super.clone();
  }

}
