/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Detailed Content-Type information from Scotty. The Content-Type of the media will typically be
 * filled in by the header or Scotty's best_guess, but this extended information provides the
 * backend with more information so that it can make a better decision if needed. This is only used
 * on media upload requests from Scotty.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ContentTypeInfo extends com.google.api.client.json.GenericJson {

  /**
   * Scotty's best guess of what the content type of the file is.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bestGuess;

  /**
   * The content type of the file derived by looking at specific bytes (i.e. "magic bytes") of the
   * actual file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fromBytes;

  /**
   * The content type of the file derived from the file extension of the original file name used by
   * the client.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fromFileName;

  /**
   * The content type of the file as specified in the request headers, multipart headers, or RUPIO
   * start request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fromHeader;

  /**
   * The content type of the file derived from the file extension of the URL path. The URL path is
   * assumed to represent a file name (which is typically only true for agents that are providing a
   * REST API).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fromUrlPath;

  /**
   * Scotty's best guess of what the content type of the file is.
   * @return value or {@code null} for none
   */
  public java.lang.String getBestGuess() {
    return bestGuess;
  }

  /**
   * Scotty's best guess of what the content type of the file is.
   * @param bestGuess bestGuess or {@code null} for none
   */
  public ContentTypeInfo setBestGuess(java.lang.String bestGuess) {
    this.bestGuess = bestGuess;
    return this;
  }

  /**
   * The content type of the file derived by looking at specific bytes (i.e. "magic bytes") of the
   * actual file.
   * @return value or {@code null} for none
   */
  public java.lang.String getFromBytes() {
    return fromBytes;
  }

  /**
   * The content type of the file derived by looking at specific bytes (i.e. "magic bytes") of the
   * actual file.
   * @param fromBytes fromBytes or {@code null} for none
   */
  public ContentTypeInfo setFromBytes(java.lang.String fromBytes) {
    this.fromBytes = fromBytes;
    return this;
  }

  /**
   * The content type of the file derived from the file extension of the original file name used by
   * the client.
   * @return value or {@code null} for none
   */
  public java.lang.String getFromFileName() {
    return fromFileName;
  }

  /**
   * The content type of the file derived from the file extension of the original file name used by
   * the client.
   * @param fromFileName fromFileName or {@code null} for none
   */
  public ContentTypeInfo setFromFileName(java.lang.String fromFileName) {
    this.fromFileName = fromFileName;
    return this;
  }

  /**
   * The content type of the file as specified in the request headers, multipart headers, or RUPIO
   * start request.
   * @return value or {@code null} for none
   */
  public java.lang.String getFromHeader() {
    return fromHeader;
  }

  /**
   * The content type of the file as specified in the request headers, multipart headers, or RUPIO
   * start request.
   * @param fromHeader fromHeader or {@code null} for none
   */
  public ContentTypeInfo setFromHeader(java.lang.String fromHeader) {
    this.fromHeader = fromHeader;
    return this;
  }

  /**
   * The content type of the file derived from the file extension of the URL path. The URL path is
   * assumed to represent a file name (which is typically only true for agents that are providing a
   * REST API).
   * @return value or {@code null} for none
   */
  public java.lang.String getFromUrlPath() {
    return fromUrlPath;
  }

  /**
   * The content type of the file derived from the file extension of the URL path. The URL path is
   * assumed to represent a file name (which is typically only true for agents that are providing a
   * REST API).
   * @param fromUrlPath fromUrlPath or {@code null} for none
   */
  public ContentTypeInfo setFromUrlPath(java.lang.String fromUrlPath) {
    this.fromUrlPath = fromUrlPath;
    return this;
  }

  @Override
  public ContentTypeInfo set(String fieldName, Object value) {
    return (ContentTypeInfo) super.set(fieldName, value);
  }

  @Override
  public ContentTypeInfo clone() {
    return (ContentTypeInfo) super.clone();
  }

}
