/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for CardBarcodeSectionDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CardBarcodeSectionDetails extends com.google.api.client.json.GenericJson {

  /**
   * Optional information to display below the barcode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BarcodeSectionDetail firstBottomDetail;

  /**
   * Optional information to display above the barcode. If `secondTopDetail` is defined, this will
   * be displayed to the start side of this detail section.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BarcodeSectionDetail firstTopDetail;

  /**
   * Optional second piece of information to display above the barcode. If `firstTopDetail` is
   * defined, this will be displayed to the end side of this detail section.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BarcodeSectionDetail secondTopDetail;

  /**
   * Optional information to display below the barcode.
   * @return value or {@code null} for none
   */
  public BarcodeSectionDetail getFirstBottomDetail() {
    return firstBottomDetail;
  }

  /**
   * Optional information to display below the barcode.
   * @param firstBottomDetail firstBottomDetail or {@code null} for none
   */
  public CardBarcodeSectionDetails setFirstBottomDetail(BarcodeSectionDetail firstBottomDetail) {
    this.firstBottomDetail = firstBottomDetail;
    return this;
  }

  /**
   * Optional information to display above the barcode. If `secondTopDetail` is defined, this will
   * be displayed to the start side of this detail section.
   * @return value or {@code null} for none
   */
  public BarcodeSectionDetail getFirstTopDetail() {
    return firstTopDetail;
  }

  /**
   * Optional information to display above the barcode. If `secondTopDetail` is defined, this will
   * be displayed to the start side of this detail section.
   * @param firstTopDetail firstTopDetail or {@code null} for none
   */
  public CardBarcodeSectionDetails setFirstTopDetail(BarcodeSectionDetail firstTopDetail) {
    this.firstTopDetail = firstTopDetail;
    return this;
  }

  /**
   * Optional second piece of information to display above the barcode. If `firstTopDetail` is
   * defined, this will be displayed to the end side of this detail section.
   * @return value or {@code null} for none
   */
  public BarcodeSectionDetail getSecondTopDetail() {
    return secondTopDetail;
  }

  /**
   * Optional second piece of information to display above the barcode. If `firstTopDetail` is
   * defined, this will be displayed to the end side of this detail section.
   * @param secondTopDetail secondTopDetail or {@code null} for none
   */
  public CardBarcodeSectionDetails setSecondTopDetail(BarcodeSectionDetail secondTopDetail) {
    this.secondTopDetail = secondTopDetail;
    return this;
  }

  @Override
  public CardBarcodeSectionDetails set(String fieldName, Object value) {
    return (CardBarcodeSectionDetails) super.set(fieldName, value);
  }

  @Override
  public CardBarcodeSectionDetails clone() {
    return (CardBarcodeSectionDetails) super.clone();
  }

}
