/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for CallbackOptions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CallbackOptions extends com.google.api.client.json.GenericJson {

  /**
   * URL for the merchant endpoint that would be called to request updates. The URL should be hosted
   * on HTTPS and robots.txt should allow the URL path to be accessible by UserAgent:Googlebot.
   * Deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String updateRequestUrl;

  /**
   * The HTTPS url configured by the merchant. The URL should be hosted on HTTPS and robots.txt
   * should allow the URL path to be accessible by UserAgent:Googlebot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * URL for the merchant endpoint that would be called to request updates. The URL should be hosted
   * on HTTPS and robots.txt should allow the URL path to be accessible by UserAgent:Googlebot.
   * Deprecated.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpdateRequestUrl() {
    return updateRequestUrl;
  }

  /**
   * URL for the merchant endpoint that would be called to request updates. The URL should be hosted
   * on HTTPS and robots.txt should allow the URL path to be accessible by UserAgent:Googlebot.
   * Deprecated.
   * @param updateRequestUrl updateRequestUrl or {@code null} for none
   */
  public CallbackOptions setUpdateRequestUrl(java.lang.String updateRequestUrl) {
    this.updateRequestUrl = updateRequestUrl;
    return this;
  }

  /**
   * The HTTPS url configured by the merchant. The URL should be hosted on HTTPS and robots.txt
   * should allow the URL path to be accessible by UserAgent:Googlebot.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * The HTTPS url configured by the merchant. The URL should be hosted on HTTPS and robots.txt
   * should allow the URL path to be accessible by UserAgent:Googlebot.
   * @param url url or {@code null} for none
   */
  public CallbackOptions setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public CallbackOptions set(String fieldName, Object value) {
    return (CallbackOptions) super.set(fieldName, value);
  }

  @Override
  public CallbackOptions clone() {
    return (CallbackOptions) super.clone();
  }

}
