/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * Model definition for AppLinkData.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppLinkData extends com.google.api.client.json.GenericJson {

  /**
   * Optional information about the partner app link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkDataAppLinkInfo androidAppLinkInfo;

  /**
   * Optional display text for the app link button. Character limit is 30.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalizedString displayText;

  /**
   * Deprecated. Links to open iOS apps are not supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkDataAppLinkInfo iosAppLinkInfo;

  /**
   * Optional information about the partner web link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AppLinkDataAppLinkInfo webAppLinkInfo;

  /**
   * Optional information about the partner app link.
   * @return value or {@code null} for none
   */
  public AppLinkDataAppLinkInfo getAndroidAppLinkInfo() {
    return androidAppLinkInfo;
  }

  /**
   * Optional information about the partner app link.
   * @param androidAppLinkInfo androidAppLinkInfo or {@code null} for none
   */
  public AppLinkData setAndroidAppLinkInfo(AppLinkDataAppLinkInfo androidAppLinkInfo) {
    this.androidAppLinkInfo = androidAppLinkInfo;
    return this;
  }

  /**
   * Optional display text for the app link button. Character limit is 30.
   * @return value or {@code null} for none
   */
  public LocalizedString getDisplayText() {
    return displayText;
  }

  /**
   * Optional display text for the app link button. Character limit is 30.
   * @param displayText displayText or {@code null} for none
   */
  public AppLinkData setDisplayText(LocalizedString displayText) {
    this.displayText = displayText;
    return this;
  }

  /**
   * Deprecated. Links to open iOS apps are not supported.
   * @return value or {@code null} for none
   */
  public AppLinkDataAppLinkInfo getIosAppLinkInfo() {
    return iosAppLinkInfo;
  }

  /**
   * Deprecated. Links to open iOS apps are not supported.
   * @param iosAppLinkInfo iosAppLinkInfo or {@code null} for none
   */
  public AppLinkData setIosAppLinkInfo(AppLinkDataAppLinkInfo iosAppLinkInfo) {
    this.iosAppLinkInfo = iosAppLinkInfo;
    return this;
  }

  /**
   * Optional information about the partner web link.
   * @return value or {@code null} for none
   */
  public AppLinkDataAppLinkInfo getWebAppLinkInfo() {
    return webAppLinkInfo;
  }

  /**
   * Optional information about the partner web link.
   * @param webAppLinkInfo webAppLinkInfo or {@code null} for none
   */
  public AppLinkData setWebAppLinkInfo(AppLinkDataAppLinkInfo webAppLinkInfo) {
    this.webAppLinkInfo = webAppLinkInfo;
    return this;
  }

  @Override
  public AppLinkData set(String fieldName, Object value) {
    return (AppLinkData) super.set(fieldName, value);
  }

  @Override
  public AppLinkData clone() {
    return (AppLinkData) super.clone();
  }

}
