/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.walletobjects.model;

/**
 * ActivationOptions for the class
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Wallet API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ActivationOptions extends com.google.api.client.json.GenericJson {

  /**
   * HTTPS URL that supports REST semantics. Would be used for requesting activation from partners
   * for given valuable, triggered by the users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String activationUrl;

  /**
   * Flag to allow users to make activation call from different device. This allows client to render
   * the activation button enabled even if the activationStatus is ACTIVATED but the requested
   * device is different than the current device.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowReactivation;

  /**
   * HTTPS URL that supports REST semantics. Would be used for requesting activation from partners
   * for given valuable, triggered by the users.
   * @return value or {@code null} for none
   */
  public java.lang.String getActivationUrl() {
    return activationUrl;
  }

  /**
   * HTTPS URL that supports REST semantics. Would be used for requesting activation from partners
   * for given valuable, triggered by the users.
   * @param activationUrl activationUrl or {@code null} for none
   */
  public ActivationOptions setActivationUrl(java.lang.String activationUrl) {
    this.activationUrl = activationUrl;
    return this;
  }

  /**
   * Flag to allow users to make activation call from different device. This allows client to render
   * the activation button enabled even if the activationStatus is ACTIVATED but the requested
   * device is different than the current device.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowReactivation() {
    return allowReactivation;
  }

  /**
   * Flag to allow users to make activation call from different device. This allows client to render
   * the activation button enabled even if the activationStatus is ACTIVATED but the requested
   * device is different than the current device.
   * @param allowReactivation allowReactivation or {@code null} for none
   */
  public ActivationOptions setAllowReactivation(java.lang.Boolean allowReactivation) {
    this.allowReactivation = allowReactivation;
    return this;
  }

  @Override
  public ActivationOptions set(String fieldName, Object value) {
    return (ActivationOptions) super.set(fieldName, value);
  }

  @Override
  public ActivationOptions clone() {
    return (ActivationOptions) super.clone();
  }

}
