/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.sheets.v4;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.sheets.v4.SheetsRequest;
import com.google.api.services.sheets.v4.SheetsRequestInitializer;
import com.google.api.services.sheets.v4.model.AppendValuesResponse;
import com.google.api.services.sheets.v4.model.BatchClearValuesByDataFilterRequest;
import com.google.api.services.sheets.v4.model.BatchClearValuesByDataFilterResponse;
import com.google.api.services.sheets.v4.model.BatchClearValuesRequest;
import com.google.api.services.sheets.v4.model.BatchClearValuesResponse;
import com.google.api.services.sheets.v4.model.BatchGetValuesByDataFilterRequest;
import com.google.api.services.sheets.v4.model.BatchGetValuesByDataFilterResponse;
import com.google.api.services.sheets.v4.model.BatchGetValuesResponse;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesByDataFilterRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesByDataFilterResponse;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesResponse;
import com.google.api.services.sheets.v4.model.ClearValuesRequest;
import com.google.api.services.sheets.v4.model.ClearValuesResponse;
import com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest;
import com.google.api.services.sheets.v4.model.DeveloperMetadata;
import com.google.api.services.sheets.v4.model.GetSpreadsheetByDataFilterRequest;
import com.google.api.services.sheets.v4.model.SearchDeveloperMetadataRequest;
import com.google.api.services.sheets.v4.model.SearchDeveloperMetadataResponse;
import com.google.api.services.sheets.v4.model.SheetProperties;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.UpdateValuesResponse;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sheets
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://sheets.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://sheets.googleapis.com/";

    public Sheets(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Sheets(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Spreadsheets spreadsheets() {
        return new Spreadsheets();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Google Sheets API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://sheets.googleapis.com/", Sheets.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Sheets.DEFAULT_BATCH_PATH);
        }

        public Sheets build() {
            return new Sheets(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setSheetsRequestInitializer(SheetsRequestInitializer sheetsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)sheetsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Spreadsheets {
        public BatchUpdate batchUpdate(String string, BatchUpdateSpreadsheetRequest batchUpdateSpreadsheetRequest) throws IOException {
            BatchUpdate batchUpdate = new BatchUpdate(string, batchUpdateSpreadsheetRequest);
            Sheets.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
            return batchUpdate;
        }

        public Create create(Spreadsheet spreadsheet) throws IOException {
            Create create = new Create(spreadsheet);
            Sheets.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Sheets.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetByDataFilter getByDataFilter(String string, GetSpreadsheetByDataFilterRequest getSpreadsheetByDataFilterRequest) throws IOException {
            GetByDataFilter getByDataFilter = new GetByDataFilter(string, getSpreadsheetByDataFilterRequest);
            Sheets.this.initialize((AbstractGoogleClientRequest<?>)getByDataFilter);
            return getByDataFilter;
        }

        public DeveloperMetadata developerMetadata() {
            return new DeveloperMetadata();
        }

        public SheetsOperations sheets() {
            return new SheetsOperations();
        }

        public Values values() {
            return new Values();
        }

        public class Values {
            public Append append(String string, String string2, ValueRange valueRange) throws IOException {
                Append append = new Append(string, string2, valueRange);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)append);
                return append;
            }

            public BatchClear batchClear(String string, BatchClearValuesRequest batchClearValuesRequest) throws IOException {
                BatchClear batchClear = new BatchClear(string, batchClearValuesRequest);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)batchClear);
                return batchClear;
            }

            public BatchClearByDataFilter batchClearByDataFilter(String string, BatchClearValuesByDataFilterRequest batchClearValuesByDataFilterRequest) throws IOException {
                BatchClearByDataFilter batchClearByDataFilter = new BatchClearByDataFilter(string, batchClearValuesByDataFilterRequest);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)batchClearByDataFilter);
                return batchClearByDataFilter;
            }

            public BatchGet batchGet(String string) throws IOException {
                BatchGet batchGet = new BatchGet(string);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)batchGet);
                return batchGet;
            }

            public BatchGetByDataFilter batchGetByDataFilter(String string, BatchGetValuesByDataFilterRequest batchGetValuesByDataFilterRequest) throws IOException {
                BatchGetByDataFilter batchGetByDataFilter = new BatchGetByDataFilter(string, batchGetValuesByDataFilterRequest);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)batchGetByDataFilter);
                return batchGetByDataFilter;
            }

            public BatchUpdate batchUpdate(String string, BatchUpdateValuesRequest batchUpdateValuesRequest) throws IOException {
                BatchUpdate batchUpdate = new BatchUpdate(string, batchUpdateValuesRequest);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)batchUpdate);
                return batchUpdate;
            }

            public BatchUpdateByDataFilter batchUpdateByDataFilter(String string, BatchUpdateValuesByDataFilterRequest batchUpdateValuesByDataFilterRequest) throws IOException {
                BatchUpdateByDataFilter batchUpdateByDataFilter = new BatchUpdateByDataFilter(string, batchUpdateValuesByDataFilterRequest);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)batchUpdateByDataFilter);
                return batchUpdateByDataFilter;
            }

            public Clear clear(String string, String string2, ClearValuesRequest clearValuesRequest) throws IOException {
                Clear clear = new Clear(string, string2, clearValuesRequest);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)clear);
                return clear;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Update update(String string, String string2, ValueRange valueRange) throws IOException {
                Update update = new Update(string, string2, valueRange);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends SheetsRequest<UpdateValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}";
                @Key
                private String spreadsheetId;
                @Key
                private String range;
                @Key
                private String valueInputOption;
                @Key
                private String responseDateTimeRenderOption;
                @Key
                private Boolean includeValuesInResponse;
                @Key
                private String responseValueRenderOption;

                protected Update(String string, String string2, ValueRange valueRange) {
                    super(Sheets.this, "PUT", REST_PATH, (Object)valueRange, UpdateValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                    this.range = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter range must be specified.");
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Update setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                public String getRange() {
                    return this.range;
                }

                public Update setRange(String string) {
                    this.range = string;
                    return this;
                }

                public String getValueInputOption() {
                    return this.valueInputOption;
                }

                public Update setValueInputOption(String string) {
                    this.valueInputOption = string;
                    return this;
                }

                public String getResponseDateTimeRenderOption() {
                    return this.responseDateTimeRenderOption;
                }

                public Update setResponseDateTimeRenderOption(String string) {
                    this.responseDateTimeRenderOption = string;
                    return this;
                }

                public Boolean getIncludeValuesInResponse() {
                    return this.includeValuesInResponse;
                }

                public Update setIncludeValuesInResponse(Boolean bl) {
                    this.includeValuesInResponse = bl;
                    return this;
                }

                public String getResponseValueRenderOption() {
                    return this.responseValueRenderOption;
                }

                public Update setResponseValueRenderOption(String string) {
                    this.responseValueRenderOption = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends SheetsRequest<ValueRange> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}";
                @Key
                private String spreadsheetId;
                @Key
                private String range;
                @Key
                private String majorDimension;
                @Key
                private String valueRenderOption;
                @Key
                private String dateTimeRenderOption;

                protected Get(String string, String string2) {
                    super(Sheets.this, "GET", REST_PATH, null, ValueRange.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                    this.range = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter range must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Get setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                public String getRange() {
                    return this.range;
                }

                public Get setRange(String string) {
                    this.range = string;
                    return this;
                }

                public String getMajorDimension() {
                    return this.majorDimension;
                }

                public Get setMajorDimension(String string) {
                    this.majorDimension = string;
                    return this;
                }

                public String getValueRenderOption() {
                    return this.valueRenderOption;
                }

                public Get setValueRenderOption(String string) {
                    this.valueRenderOption = string;
                    return this;
                }

                public String getDateTimeRenderOption() {
                    return this.dateTimeRenderOption;
                }

                public Get setDateTimeRenderOption(String string) {
                    this.dateTimeRenderOption = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Clear
            extends SheetsRequest<ClearValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}:clear";
                @Key
                private String spreadsheetId;
                @Key
                private String range;

                protected Clear(String string, String string2, ClearValuesRequest clearValuesRequest) {
                    super(Sheets.this, "POST", REST_PATH, (Object)clearValuesRequest, ClearValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                    this.range = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter range must be specified.");
                }

                public Clear set$Xgafv(String string) {
                    return (Clear)super.set$Xgafv(string);
                }

                public Clear setAccessToken(String string) {
                    return (Clear)super.setAccessToken(string);
                }

                public Clear setAlt(String string) {
                    return (Clear)super.setAlt(string);
                }

                public Clear setCallback(String string) {
                    return (Clear)super.setCallback(string);
                }

                public Clear setFields(String string) {
                    return (Clear)super.setFields(string);
                }

                public Clear setKey(String string) {
                    return (Clear)super.setKey(string);
                }

                public Clear setOauthToken(String string) {
                    return (Clear)super.setOauthToken(string);
                }

                public Clear setPrettyPrint(Boolean bl) {
                    return (Clear)super.setPrettyPrint(bl);
                }

                public Clear setQuotaUser(String string) {
                    return (Clear)super.setQuotaUser(string);
                }

                public Clear setUploadType(String string) {
                    return (Clear)super.setUploadType(string);
                }

                public Clear setUploadProtocol(String string) {
                    return (Clear)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Clear setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                public String getRange() {
                    return this.range;
                }

                public Clear setRange(String string) {
                    this.range = string;
                    return this;
                }

                @Override
                public Clear set(String string, Object object) {
                    return (Clear)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchUpdateByDataFilter
            extends SheetsRequest<BatchUpdateValuesByDataFilterResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchUpdateByDataFilter";
                @Key
                private String spreadsheetId;

                protected BatchUpdateByDataFilter(String string, BatchUpdateValuesByDataFilterRequest batchUpdateValuesByDataFilterRequest) {
                    super(Sheets.this, "POST", REST_PATH, (Object)batchUpdateValuesByDataFilterRequest, BatchUpdateValuesByDataFilterResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public BatchUpdateByDataFilter set$Xgafv(String string) {
                    return (BatchUpdateByDataFilter)super.set$Xgafv(string);
                }

                public BatchUpdateByDataFilter setAccessToken(String string) {
                    return (BatchUpdateByDataFilter)super.setAccessToken(string);
                }

                public BatchUpdateByDataFilter setAlt(String string) {
                    return (BatchUpdateByDataFilter)super.setAlt(string);
                }

                public BatchUpdateByDataFilter setCallback(String string) {
                    return (BatchUpdateByDataFilter)super.setCallback(string);
                }

                public BatchUpdateByDataFilter setFields(String string) {
                    return (BatchUpdateByDataFilter)super.setFields(string);
                }

                public BatchUpdateByDataFilter setKey(String string) {
                    return (BatchUpdateByDataFilter)super.setKey(string);
                }

                public BatchUpdateByDataFilter setOauthToken(String string) {
                    return (BatchUpdateByDataFilter)super.setOauthToken(string);
                }

                public BatchUpdateByDataFilter setPrettyPrint(Boolean bl) {
                    return (BatchUpdateByDataFilter)super.setPrettyPrint(bl);
                }

                public BatchUpdateByDataFilter setQuotaUser(String string) {
                    return (BatchUpdateByDataFilter)super.setQuotaUser(string);
                }

                public BatchUpdateByDataFilter setUploadType(String string) {
                    return (BatchUpdateByDataFilter)super.setUploadType(string);
                }

                public BatchUpdateByDataFilter setUploadProtocol(String string) {
                    return (BatchUpdateByDataFilter)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchUpdateByDataFilter setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                @Override
                public BatchUpdateByDataFilter set(String string, Object object) {
                    return (BatchUpdateByDataFilter)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchUpdate
            extends SheetsRequest<BatchUpdateValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchUpdate";
                @Key
                private String spreadsheetId;

                protected BatchUpdate(String string, BatchUpdateValuesRequest batchUpdateValuesRequest) {
                    super(Sheets.this, "POST", REST_PATH, (Object)batchUpdateValuesRequest, BatchUpdateValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public BatchUpdate set$Xgafv(String string) {
                    return (BatchUpdate)super.set$Xgafv(string);
                }

                public BatchUpdate setAccessToken(String string) {
                    return (BatchUpdate)super.setAccessToken(string);
                }

                public BatchUpdate setAlt(String string) {
                    return (BatchUpdate)super.setAlt(string);
                }

                public BatchUpdate setCallback(String string) {
                    return (BatchUpdate)super.setCallback(string);
                }

                public BatchUpdate setFields(String string) {
                    return (BatchUpdate)super.setFields(string);
                }

                public BatchUpdate setKey(String string) {
                    return (BatchUpdate)super.setKey(string);
                }

                public BatchUpdate setOauthToken(String string) {
                    return (BatchUpdate)super.setOauthToken(string);
                }

                public BatchUpdate setPrettyPrint(Boolean bl) {
                    return (BatchUpdate)super.setPrettyPrint(bl);
                }

                public BatchUpdate setQuotaUser(String string) {
                    return (BatchUpdate)super.setQuotaUser(string);
                }

                public BatchUpdate setUploadType(String string) {
                    return (BatchUpdate)super.setUploadType(string);
                }

                public BatchUpdate setUploadProtocol(String string) {
                    return (BatchUpdate)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchUpdate setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                @Override
                public BatchUpdate set(String string, Object object) {
                    return (BatchUpdate)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchGetByDataFilter
            extends SheetsRequest<BatchGetValuesByDataFilterResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchGetByDataFilter";
                @Key
                private String spreadsheetId;

                protected BatchGetByDataFilter(String string, BatchGetValuesByDataFilterRequest batchGetValuesByDataFilterRequest) {
                    super(Sheets.this, "POST", REST_PATH, (Object)batchGetValuesByDataFilterRequest, BatchGetValuesByDataFilterResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public BatchGetByDataFilter set$Xgafv(String string) {
                    return (BatchGetByDataFilter)super.set$Xgafv(string);
                }

                public BatchGetByDataFilter setAccessToken(String string) {
                    return (BatchGetByDataFilter)super.setAccessToken(string);
                }

                public BatchGetByDataFilter setAlt(String string) {
                    return (BatchGetByDataFilter)super.setAlt(string);
                }

                public BatchGetByDataFilter setCallback(String string) {
                    return (BatchGetByDataFilter)super.setCallback(string);
                }

                public BatchGetByDataFilter setFields(String string) {
                    return (BatchGetByDataFilter)super.setFields(string);
                }

                public BatchGetByDataFilter setKey(String string) {
                    return (BatchGetByDataFilter)super.setKey(string);
                }

                public BatchGetByDataFilter setOauthToken(String string) {
                    return (BatchGetByDataFilter)super.setOauthToken(string);
                }

                public BatchGetByDataFilter setPrettyPrint(Boolean bl) {
                    return (BatchGetByDataFilter)super.setPrettyPrint(bl);
                }

                public BatchGetByDataFilter setQuotaUser(String string) {
                    return (BatchGetByDataFilter)super.setQuotaUser(string);
                }

                public BatchGetByDataFilter setUploadType(String string) {
                    return (BatchGetByDataFilter)super.setUploadType(string);
                }

                public BatchGetByDataFilter setUploadProtocol(String string) {
                    return (BatchGetByDataFilter)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchGetByDataFilter setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                @Override
                public BatchGetByDataFilter set(String string, Object object) {
                    return (BatchGetByDataFilter)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchGet
            extends SheetsRequest<BatchGetValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchGet";
                @Key
                private String spreadsheetId;
                @Key
                private String valueRenderOption;
                @Key
                private String dateTimeRenderOption;
                @Key
                private List<String> ranges;
                @Key
                private String majorDimension;

                protected BatchGet(String string) {
                    super(Sheets.this, "GET", REST_PATH, null, BatchGetValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public BatchGet set$Xgafv(String string) {
                    return (BatchGet)super.set$Xgafv(string);
                }

                public BatchGet setAccessToken(String string) {
                    return (BatchGet)super.setAccessToken(string);
                }

                public BatchGet setAlt(String string) {
                    return (BatchGet)super.setAlt(string);
                }

                public BatchGet setCallback(String string) {
                    return (BatchGet)super.setCallback(string);
                }

                public BatchGet setFields(String string) {
                    return (BatchGet)super.setFields(string);
                }

                public BatchGet setKey(String string) {
                    return (BatchGet)super.setKey(string);
                }

                public BatchGet setOauthToken(String string) {
                    return (BatchGet)super.setOauthToken(string);
                }

                public BatchGet setPrettyPrint(Boolean bl) {
                    return (BatchGet)super.setPrettyPrint(bl);
                }

                public BatchGet setQuotaUser(String string) {
                    return (BatchGet)super.setQuotaUser(string);
                }

                public BatchGet setUploadType(String string) {
                    return (BatchGet)super.setUploadType(string);
                }

                public BatchGet setUploadProtocol(String string) {
                    return (BatchGet)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchGet setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                public String getValueRenderOption() {
                    return this.valueRenderOption;
                }

                public BatchGet setValueRenderOption(String string) {
                    this.valueRenderOption = string;
                    return this;
                }

                public String getDateTimeRenderOption() {
                    return this.dateTimeRenderOption;
                }

                public BatchGet setDateTimeRenderOption(String string) {
                    this.dateTimeRenderOption = string;
                    return this;
                }

                public List<String> getRanges() {
                    return this.ranges;
                }

                public BatchGet setRanges(List<String> list) {
                    this.ranges = list;
                    return this;
                }

                public String getMajorDimension() {
                    return this.majorDimension;
                }

                public BatchGet setMajorDimension(String string) {
                    this.majorDimension = string;
                    return this;
                }

                @Override
                public BatchGet set(String string, Object object) {
                    return (BatchGet)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchClearByDataFilter
            extends SheetsRequest<BatchClearValuesByDataFilterResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchClearByDataFilter";
                @Key
                private String spreadsheetId;

                protected BatchClearByDataFilter(String string, BatchClearValuesByDataFilterRequest batchClearValuesByDataFilterRequest) {
                    super(Sheets.this, "POST", REST_PATH, (Object)batchClearValuesByDataFilterRequest, BatchClearValuesByDataFilterResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public BatchClearByDataFilter set$Xgafv(String string) {
                    return (BatchClearByDataFilter)super.set$Xgafv(string);
                }

                public BatchClearByDataFilter setAccessToken(String string) {
                    return (BatchClearByDataFilter)super.setAccessToken(string);
                }

                public BatchClearByDataFilter setAlt(String string) {
                    return (BatchClearByDataFilter)super.setAlt(string);
                }

                public BatchClearByDataFilter setCallback(String string) {
                    return (BatchClearByDataFilter)super.setCallback(string);
                }

                public BatchClearByDataFilter setFields(String string) {
                    return (BatchClearByDataFilter)super.setFields(string);
                }

                public BatchClearByDataFilter setKey(String string) {
                    return (BatchClearByDataFilter)super.setKey(string);
                }

                public BatchClearByDataFilter setOauthToken(String string) {
                    return (BatchClearByDataFilter)super.setOauthToken(string);
                }

                public BatchClearByDataFilter setPrettyPrint(Boolean bl) {
                    return (BatchClearByDataFilter)super.setPrettyPrint(bl);
                }

                public BatchClearByDataFilter setQuotaUser(String string) {
                    return (BatchClearByDataFilter)super.setQuotaUser(string);
                }

                public BatchClearByDataFilter setUploadType(String string) {
                    return (BatchClearByDataFilter)super.setUploadType(string);
                }

                public BatchClearByDataFilter setUploadProtocol(String string) {
                    return (BatchClearByDataFilter)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchClearByDataFilter setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                @Override
                public BatchClearByDataFilter set(String string, Object object) {
                    return (BatchClearByDataFilter)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class BatchClear
            extends SheetsRequest<BatchClearValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchClear";
                @Key
                private String spreadsheetId;

                protected BatchClear(String string, BatchClearValuesRequest batchClearValuesRequest) {
                    super(Sheets.this, "POST", REST_PATH, (Object)batchClearValuesRequest, BatchClearValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public BatchClear set$Xgafv(String string) {
                    return (BatchClear)super.set$Xgafv(string);
                }

                public BatchClear setAccessToken(String string) {
                    return (BatchClear)super.setAccessToken(string);
                }

                public BatchClear setAlt(String string) {
                    return (BatchClear)super.setAlt(string);
                }

                public BatchClear setCallback(String string) {
                    return (BatchClear)super.setCallback(string);
                }

                public BatchClear setFields(String string) {
                    return (BatchClear)super.setFields(string);
                }

                public BatchClear setKey(String string) {
                    return (BatchClear)super.setKey(string);
                }

                public BatchClear setOauthToken(String string) {
                    return (BatchClear)super.setOauthToken(string);
                }

                public BatchClear setPrettyPrint(Boolean bl) {
                    return (BatchClear)super.setPrettyPrint(bl);
                }

                public BatchClear setQuotaUser(String string) {
                    return (BatchClear)super.setQuotaUser(string);
                }

                public BatchClear setUploadType(String string) {
                    return (BatchClear)super.setUploadType(string);
                }

                public BatchClear setUploadProtocol(String string) {
                    return (BatchClear)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchClear setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                @Override
                public BatchClear set(String string, Object object) {
                    return (BatchClear)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Append
            extends SheetsRequest<AppendValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}:append";
                @Key
                private String spreadsheetId;
                @Key
                private String range;
                @Key
                private String insertDataOption;
                @Key
                private String valueInputOption;
                @Key
                private String responseDateTimeRenderOption;
                @Key
                private Boolean includeValuesInResponse;
                @Key
                private String responseValueRenderOption;

                protected Append(String string, String string2, ValueRange valueRange) {
                    super(Sheets.this, "POST", REST_PATH, (Object)valueRange, AppendValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                    this.range = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter range must be specified.");
                }

                public Append set$Xgafv(String string) {
                    return (Append)super.set$Xgafv(string);
                }

                public Append setAccessToken(String string) {
                    return (Append)super.setAccessToken(string);
                }

                public Append setAlt(String string) {
                    return (Append)super.setAlt(string);
                }

                public Append setCallback(String string) {
                    return (Append)super.setCallback(string);
                }

                public Append setFields(String string) {
                    return (Append)super.setFields(string);
                }

                public Append setKey(String string) {
                    return (Append)super.setKey(string);
                }

                public Append setOauthToken(String string) {
                    return (Append)super.setOauthToken(string);
                }

                public Append setPrettyPrint(Boolean bl) {
                    return (Append)super.setPrettyPrint(bl);
                }

                public Append setQuotaUser(String string) {
                    return (Append)super.setQuotaUser(string);
                }

                public Append setUploadType(String string) {
                    return (Append)super.setUploadType(string);
                }

                public Append setUploadProtocol(String string) {
                    return (Append)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Append setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                public String getRange() {
                    return this.range;
                }

                public Append setRange(String string) {
                    this.range = string;
                    return this;
                }

                public String getInsertDataOption() {
                    return this.insertDataOption;
                }

                public Append setInsertDataOption(String string) {
                    this.insertDataOption = string;
                    return this;
                }

                public String getValueInputOption() {
                    return this.valueInputOption;
                }

                public Append setValueInputOption(String string) {
                    this.valueInputOption = string;
                    return this;
                }

                public String getResponseDateTimeRenderOption() {
                    return this.responseDateTimeRenderOption;
                }

                public Append setResponseDateTimeRenderOption(String string) {
                    this.responseDateTimeRenderOption = string;
                    return this;
                }

                public Boolean getIncludeValuesInResponse() {
                    return this.includeValuesInResponse;
                }

                public Append setIncludeValuesInResponse(Boolean bl) {
                    this.includeValuesInResponse = bl;
                    return this;
                }

                public String getResponseValueRenderOption() {
                    return this.responseValueRenderOption;
                }

                public Append setResponseValueRenderOption(String string) {
                    this.responseValueRenderOption = string;
                    return this;
                }

                @Override
                public Append set(String string, Object object) {
                    return (Append)super.set(string, object);
                }
            }
        }

        public class SheetsOperations {
            public CopyTo copyTo(String string, Integer n, CopySheetToAnotherSpreadsheetRequest copySheetToAnotherSpreadsheetRequest) throws IOException {
                CopyTo copyTo = new CopyTo(string, n, copySheetToAnotherSpreadsheetRequest);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)copyTo);
                return copyTo;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class CopyTo
            extends SheetsRequest<SheetProperties> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/sheets/{sheetId}:copyTo";
                @Key
                private String spreadsheetId;
                @Key
                private Integer sheetId;

                protected CopyTo(String string, Integer n, CopySheetToAnotherSpreadsheetRequest copySheetToAnotherSpreadsheetRequest) {
                    super(Sheets.this, "POST", REST_PATH, (Object)copySheetToAnotherSpreadsheetRequest, SheetProperties.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                    this.sheetId = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter sheetId must be specified.");
                }

                public CopyTo set$Xgafv(String string) {
                    return (CopyTo)super.set$Xgafv(string);
                }

                public CopyTo setAccessToken(String string) {
                    return (CopyTo)super.setAccessToken(string);
                }

                public CopyTo setAlt(String string) {
                    return (CopyTo)super.setAlt(string);
                }

                public CopyTo setCallback(String string) {
                    return (CopyTo)super.setCallback(string);
                }

                public CopyTo setFields(String string) {
                    return (CopyTo)super.setFields(string);
                }

                public CopyTo setKey(String string) {
                    return (CopyTo)super.setKey(string);
                }

                public CopyTo setOauthToken(String string) {
                    return (CopyTo)super.setOauthToken(string);
                }

                public CopyTo setPrettyPrint(Boolean bl) {
                    return (CopyTo)super.setPrettyPrint(bl);
                }

                public CopyTo setQuotaUser(String string) {
                    return (CopyTo)super.setQuotaUser(string);
                }

                public CopyTo setUploadType(String string) {
                    return (CopyTo)super.setUploadType(string);
                }

                public CopyTo setUploadProtocol(String string) {
                    return (CopyTo)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public CopyTo setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                public Integer getSheetId() {
                    return this.sheetId;
                }

                public CopyTo setSheetId(Integer n) {
                    this.sheetId = n;
                    return this;
                }

                @Override
                public CopyTo set(String string, Object object) {
                    return (CopyTo)super.set(string, object);
                }
            }
        }

        public class DeveloperMetadata {
            public Get get(String string, Integer n) throws IOException {
                Get get = new Get(string, n);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Search search(String string, SearchDeveloperMetadataRequest searchDeveloperMetadataRequest) throws IOException {
                Search search = new Search(string, searchDeveloperMetadataRequest);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)search);
                return search;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Search
            extends SheetsRequest<SearchDeveloperMetadataResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/developerMetadata:search";
                @Key
                private String spreadsheetId;

                protected Search(String string, SearchDeveloperMetadataRequest searchDeveloperMetadataRequest) {
                    super(Sheets.this, "POST", REST_PATH, (Object)searchDeveloperMetadataRequest, SearchDeveloperMetadataResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public Search set$Xgafv(String string) {
                    return (Search)super.set$Xgafv(string);
                }

                public Search setAccessToken(String string) {
                    return (Search)super.setAccessToken(string);
                }

                public Search setAlt(String string) {
                    return (Search)super.setAlt(string);
                }

                public Search setCallback(String string) {
                    return (Search)super.setCallback(string);
                }

                public Search setFields(String string) {
                    return (Search)super.setFields(string);
                }

                public Search setKey(String string) {
                    return (Search)super.setKey(string);
                }

                public Search setOauthToken(String string) {
                    return (Search)super.setOauthToken(string);
                }

                public Search setPrettyPrint(Boolean bl) {
                    return (Search)super.setPrettyPrint(bl);
                }

                public Search setQuotaUser(String string) {
                    return (Search)super.setQuotaUser(string);
                }

                public Search setUploadType(String string) {
                    return (Search)super.setUploadType(string);
                }

                public Search setUploadProtocol(String string) {
                    return (Search)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Search setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                @Override
                public Search set(String string, Object object) {
                    return (Search)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends SheetsRequest<com.google.api.services.sheets.v4.model.DeveloperMetadata> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/developerMetadata/{metadataId}";
                @Key
                private String spreadsheetId;
                @Key
                private Integer metadataId;

                protected Get(String string, Integer n) {
                    super(Sheets.this, "GET", REST_PATH, null, com.google.api.services.sheets.v4.model.DeveloperMetadata.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
                    this.metadataId = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter metadataId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Get setSpreadsheetId(String string) {
                    this.spreadsheetId = string;
                    return this;
                }

                public Integer getMetadataId() {
                    return this.metadataId;
                }

                public Get setMetadataId(Integer n) {
                    this.metadataId = n;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetByDataFilter
        extends SheetsRequest<Spreadsheet> {
            private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}:getByDataFilter";
            @Key
            private String spreadsheetId;

            protected GetByDataFilter(String string, GetSpreadsheetByDataFilterRequest getSpreadsheetByDataFilterRequest) {
                super(Sheets.this, "POST", REST_PATH, (Object)getSpreadsheetByDataFilterRequest, Spreadsheet.class);
                this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
            }

            public GetByDataFilter set$Xgafv(String string) {
                return (GetByDataFilter)super.set$Xgafv(string);
            }

            public GetByDataFilter setAccessToken(String string) {
                return (GetByDataFilter)super.setAccessToken(string);
            }

            public GetByDataFilter setAlt(String string) {
                return (GetByDataFilter)super.setAlt(string);
            }

            public GetByDataFilter setCallback(String string) {
                return (GetByDataFilter)super.setCallback(string);
            }

            public GetByDataFilter setFields(String string) {
                return (GetByDataFilter)super.setFields(string);
            }

            public GetByDataFilter setKey(String string) {
                return (GetByDataFilter)super.setKey(string);
            }

            public GetByDataFilter setOauthToken(String string) {
                return (GetByDataFilter)super.setOauthToken(string);
            }

            public GetByDataFilter setPrettyPrint(Boolean bl) {
                return (GetByDataFilter)super.setPrettyPrint(bl);
            }

            public GetByDataFilter setQuotaUser(String string) {
                return (GetByDataFilter)super.setQuotaUser(string);
            }

            public GetByDataFilter setUploadType(String string) {
                return (GetByDataFilter)super.setUploadType(string);
            }

            public GetByDataFilter setUploadProtocol(String string) {
                return (GetByDataFilter)super.setUploadProtocol(string);
            }

            public String getSpreadsheetId() {
                return this.spreadsheetId;
            }

            public GetByDataFilter setSpreadsheetId(String string) {
                this.spreadsheetId = string;
                return this;
            }

            @Override
            public GetByDataFilter set(String string, Object object) {
                return (GetByDataFilter)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends SheetsRequest<Spreadsheet> {
            private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}";
            @Key
            private String spreadsheetId;
            @Key
            private List<String> ranges;
            @Key
            private Boolean includeGridData;

            protected Get(String string) {
                super(Sheets.this, "GET", REST_PATH, null, Spreadsheet.class);
                this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getSpreadsheetId() {
                return this.spreadsheetId;
            }

            public Get setSpreadsheetId(String string) {
                this.spreadsheetId = string;
                return this;
            }

            public List<String> getRanges() {
                return this.ranges;
            }

            public Get setRanges(List<String> list) {
                this.ranges = list;
                return this;
            }

            public Boolean getIncludeGridData() {
                return this.includeGridData;
            }

            public Get setIncludeGridData(Boolean bl) {
                this.includeGridData = bl;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends SheetsRequest<Spreadsheet> {
            private static final String REST_PATH = "v4/spreadsheets";

            protected Create(Spreadsheet spreadsheet) {
                super(Sheets.this, "POST", REST_PATH, (Object)spreadsheet, Spreadsheet.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class BatchUpdate
        extends SheetsRequest<BatchUpdateSpreadsheetResponse> {
            private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}:batchUpdate";
            @Key
            private String spreadsheetId;

            protected BatchUpdate(String string, BatchUpdateSpreadsheetRequest batchUpdateSpreadsheetRequest) {
                super(Sheets.this, "POST", REST_PATH, (Object)batchUpdateSpreadsheetRequest, BatchUpdateSpreadsheetResponse.class);
                this.spreadsheetId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter spreadsheetId must be specified.");
            }

            public BatchUpdate set$Xgafv(String string) {
                return (BatchUpdate)super.set$Xgafv(string);
            }

            public BatchUpdate setAccessToken(String string) {
                return (BatchUpdate)super.setAccessToken(string);
            }

            public BatchUpdate setAlt(String string) {
                return (BatchUpdate)super.setAlt(string);
            }

            public BatchUpdate setCallback(String string) {
                return (BatchUpdate)super.setCallback(string);
            }

            public BatchUpdate setFields(String string) {
                return (BatchUpdate)super.setFields(string);
            }

            public BatchUpdate setKey(String string) {
                return (BatchUpdate)super.setKey(string);
            }

            public BatchUpdate setOauthToken(String string) {
                return (BatchUpdate)super.setOauthToken(string);
            }

            public BatchUpdate setPrettyPrint(Boolean bl) {
                return (BatchUpdate)super.setPrettyPrint(bl);
            }

            public BatchUpdate setQuotaUser(String string) {
                return (BatchUpdate)super.setQuotaUser(string);
            }

            public BatchUpdate setUploadType(String string) {
                return (BatchUpdate)super.setUploadType(string);
            }

            public BatchUpdate setUploadProtocol(String string) {
                return (BatchUpdate)super.setUploadProtocol(string);
            }

            public String getSpreadsheetId() {
                return this.spreadsheetId;
            }

            public BatchUpdate setSpreadsheetId(String string) {
                this.spreadsheetId = string;
                return this;
            }

            @Override
            public BatchUpdate set(String string, Object object) {
                return (BatchUpdate)super.set(string, object);
            }
        }
    }
}

