/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.oauth2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.oauth2.Oauth2Request;
import com.google.api.services.oauth2.Oauth2RequestInitializer;
import com.google.api.services.oauth2.model.Jwk;
import com.google.api.services.oauth2.model.Raw;
import com.google.api.services.oauth2.model.Userinfoplus;
import com.google.api.services.oauth2.model.X509;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Oauth2
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/";

    public Oauth2(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Oauth2(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Userinfo userinfo() {
        return new Userinfo();
    }

    public GetCertForOpenIdConnect getCertForOpenIdConnect() throws IOException {
        GetCertForOpenIdConnect getCertForOpenIdConnect = new GetCertForOpenIdConnect();
        this.initialize((AbstractGoogleClientRequest<?>)getCertForOpenIdConnect);
        return getCertForOpenIdConnect;
    }

    public GetCertForOpenIdConnectRaw getCertForOpenIdConnectRaw() throws IOException {
        GetCertForOpenIdConnectRaw getCertForOpenIdConnectRaw = new GetCertForOpenIdConnectRaw();
        this.initialize((AbstractGoogleClientRequest<?>)getCertForOpenIdConnectRaw);
        return getCertForOpenIdConnectRaw;
    }

    public GetRobotJwk getRobotJwk(String string) throws IOException {
        GetRobotJwk getRobotJwk = new GetRobotJwk(string);
        this.initialize((AbstractGoogleClientRequest<?>)getRobotJwk);
        return getRobotJwk;
    }

    public GetRobotMetadataRaw getRobotMetadataRaw(String string) throws IOException {
        GetRobotMetadataRaw getRobotMetadataRaw = new GetRobotMetadataRaw(string);
        this.initialize((AbstractGoogleClientRequest<?>)getRobotMetadataRaw);
        return getRobotMetadataRaw;
    }

    public GetRobotMetadataX509 getRobotMetadataX509(String string) throws IOException {
        GetRobotMetadataX509 getRobotMetadataX509 = new GetRobotMetadataX509(string);
        this.initialize((AbstractGoogleClientRequest<?>)getRobotMetadataX509);
        return getRobotMetadataX509;
    }

    public Tokeninfo tokeninfo() throws IOException {
        Tokeninfo tokeninfo = new Tokeninfo();
        this.initialize((AbstractGoogleClientRequest<?>)tokeninfo);
        return tokeninfo;
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the Google OAuth2 API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://www.googleapis.com/", Oauth2.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Oauth2 build() {
            return new Oauth2(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setOauth2RequestInitializer(Oauth2RequestInitializer oauth2RequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)oauth2RequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Tokeninfo
    extends Oauth2Request<com.google.api.services.oauth2.model.Tokeninfo> {
        private static final String REST_PATH = "oauth2/v1/tokeninfo";
        @Key(value="access_token")
        private String accessToken;
        @Key(value="id_token")
        private String idToken;

        protected Tokeninfo() {
            super(Oauth2.this, "POST", REST_PATH, null, com.google.api.services.oauth2.model.Tokeninfo.class);
        }

        public Tokeninfo setAlt(String string) {
            return (Tokeninfo)super.setAlt(string);
        }

        public Tokeninfo setFields(String string) {
            return (Tokeninfo)super.setFields(string);
        }

        public Tokeninfo setKey(String string) {
            return (Tokeninfo)super.setKey(string);
        }

        public Tokeninfo setOauthToken(String string) {
            return (Tokeninfo)super.setOauthToken(string);
        }

        public Tokeninfo setPrettyPrint(Boolean bl) {
            return (Tokeninfo)super.setPrettyPrint(bl);
        }

        public Tokeninfo setQuotaUser(String string) {
            return (Tokeninfo)super.setQuotaUser(string);
        }

        public Tokeninfo setUserIp(String string) {
            return (Tokeninfo)super.setUserIp(string);
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Tokeninfo setAccessToken(String string) {
            this.accessToken = string;
            return this;
        }

        public String getIdToken() {
            return this.idToken;
        }

        public Tokeninfo setIdToken(String string) {
            this.idToken = string;
            return this;
        }

        @Override
        public Tokeninfo set(String string, Object object) {
            return (Tokeninfo)super.set(string, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetRobotMetadataX509
    extends Oauth2Request<X509> {
        private static final String REST_PATH = "service_accounts/v1/metadata/x509/{robotEmail}";
        @Key
        private String robotEmail;

        protected GetRobotMetadataX509(String string) {
            super(Oauth2.this, "GET", REST_PATH, null, X509.class);
            this.robotEmail = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter robotEmail must be specified.");
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetRobotMetadataX509 setAlt(String string) {
            return (GetRobotMetadataX509)super.setAlt(string);
        }

        public GetRobotMetadataX509 setFields(String string) {
            return (GetRobotMetadataX509)super.setFields(string);
        }

        public GetRobotMetadataX509 setKey(String string) {
            return (GetRobotMetadataX509)super.setKey(string);
        }

        public GetRobotMetadataX509 setOauthToken(String string) {
            return (GetRobotMetadataX509)super.setOauthToken(string);
        }

        public GetRobotMetadataX509 setPrettyPrint(Boolean bl) {
            return (GetRobotMetadataX509)super.setPrettyPrint(bl);
        }

        public GetRobotMetadataX509 setQuotaUser(String string) {
            return (GetRobotMetadataX509)super.setQuotaUser(string);
        }

        public GetRobotMetadataX509 setUserIp(String string) {
            return (GetRobotMetadataX509)super.setUserIp(string);
        }

        public String getRobotEmail() {
            return this.robotEmail;
        }

        public GetRobotMetadataX509 setRobotEmail(String string) {
            this.robotEmail = string;
            return this;
        }

        @Override
        public GetRobotMetadataX509 set(String string, Object object) {
            return (GetRobotMetadataX509)super.set(string, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetRobotMetadataRaw
    extends Oauth2Request<Raw> {
        private static final String REST_PATH = "service_accounts/v1/metadata/raw/{robotEmail}";
        @Key
        private String robotEmail;

        protected GetRobotMetadataRaw(String string) {
            super(Oauth2.this, "GET", REST_PATH, null, Raw.class);
            this.robotEmail = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter robotEmail must be specified.");
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetRobotMetadataRaw setAlt(String string) {
            return (GetRobotMetadataRaw)super.setAlt(string);
        }

        public GetRobotMetadataRaw setFields(String string) {
            return (GetRobotMetadataRaw)super.setFields(string);
        }

        public GetRobotMetadataRaw setKey(String string) {
            return (GetRobotMetadataRaw)super.setKey(string);
        }

        public GetRobotMetadataRaw setOauthToken(String string) {
            return (GetRobotMetadataRaw)super.setOauthToken(string);
        }

        public GetRobotMetadataRaw setPrettyPrint(Boolean bl) {
            return (GetRobotMetadataRaw)super.setPrettyPrint(bl);
        }

        public GetRobotMetadataRaw setQuotaUser(String string) {
            return (GetRobotMetadataRaw)super.setQuotaUser(string);
        }

        public GetRobotMetadataRaw setUserIp(String string) {
            return (GetRobotMetadataRaw)super.setUserIp(string);
        }

        public String getRobotEmail() {
            return this.robotEmail;
        }

        public GetRobotMetadataRaw setRobotEmail(String string) {
            this.robotEmail = string;
            return this;
        }

        @Override
        public GetRobotMetadataRaw set(String string, Object object) {
            return (GetRobotMetadataRaw)super.set(string, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetRobotJwk
    extends Oauth2Request<Jwk> {
        private static final String REST_PATH = "service_accounts/v1/jwk/{robotEmail}";
        @Key
        private String robotEmail;

        protected GetRobotJwk(String string) {
            super(Oauth2.this, "GET", REST_PATH, null, Jwk.class);
            this.robotEmail = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter robotEmail must be specified.");
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetRobotJwk setAlt(String string) {
            return (GetRobotJwk)super.setAlt(string);
        }

        public GetRobotJwk setFields(String string) {
            return (GetRobotJwk)super.setFields(string);
        }

        public GetRobotJwk setKey(String string) {
            return (GetRobotJwk)super.setKey(string);
        }

        public GetRobotJwk setOauthToken(String string) {
            return (GetRobotJwk)super.setOauthToken(string);
        }

        public GetRobotJwk setPrettyPrint(Boolean bl) {
            return (GetRobotJwk)super.setPrettyPrint(bl);
        }

        public GetRobotJwk setQuotaUser(String string) {
            return (GetRobotJwk)super.setQuotaUser(string);
        }

        public GetRobotJwk setUserIp(String string) {
            return (GetRobotJwk)super.setUserIp(string);
        }

        public String getRobotEmail() {
            return this.robotEmail;
        }

        public GetRobotJwk setRobotEmail(String string) {
            this.robotEmail = string;
            return this;
        }

        @Override
        public GetRobotJwk set(String string, Object object) {
            return (GetRobotJwk)super.set(string, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetCertForOpenIdConnectRaw
    extends Oauth2Request<Raw> {
        private static final String REST_PATH = "oauth2/v1/raw_public_keys";

        protected GetCertForOpenIdConnectRaw() {
            super(Oauth2.this, "GET", REST_PATH, null, Raw.class);
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetCertForOpenIdConnectRaw setAlt(String string) {
            return (GetCertForOpenIdConnectRaw)super.setAlt(string);
        }

        public GetCertForOpenIdConnectRaw setFields(String string) {
            return (GetCertForOpenIdConnectRaw)super.setFields(string);
        }

        public GetCertForOpenIdConnectRaw setKey(String string) {
            return (GetCertForOpenIdConnectRaw)super.setKey(string);
        }

        public GetCertForOpenIdConnectRaw setOauthToken(String string) {
            return (GetCertForOpenIdConnectRaw)super.setOauthToken(string);
        }

        public GetCertForOpenIdConnectRaw setPrettyPrint(Boolean bl) {
            return (GetCertForOpenIdConnectRaw)super.setPrettyPrint(bl);
        }

        public GetCertForOpenIdConnectRaw setQuotaUser(String string) {
            return (GetCertForOpenIdConnectRaw)super.setQuotaUser(string);
        }

        public GetCertForOpenIdConnectRaw setUserIp(String string) {
            return (GetCertForOpenIdConnectRaw)super.setUserIp(string);
        }

        @Override
        public GetCertForOpenIdConnectRaw set(String string, Object object) {
            return (GetCertForOpenIdConnectRaw)super.set(string, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetCertForOpenIdConnect
    extends Oauth2Request<X509> {
        private static final String REST_PATH = "oauth2/v1/certs";

        protected GetCertForOpenIdConnect() {
            super(Oauth2.this, "GET", REST_PATH, null, X509.class);
        }

        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetCertForOpenIdConnect setAlt(String string) {
            return (GetCertForOpenIdConnect)super.setAlt(string);
        }

        public GetCertForOpenIdConnect setFields(String string) {
            return (GetCertForOpenIdConnect)super.setFields(string);
        }

        public GetCertForOpenIdConnect setKey(String string) {
            return (GetCertForOpenIdConnect)super.setKey(string);
        }

        public GetCertForOpenIdConnect setOauthToken(String string) {
            return (GetCertForOpenIdConnect)super.setOauthToken(string);
        }

        public GetCertForOpenIdConnect setPrettyPrint(Boolean bl) {
            return (GetCertForOpenIdConnect)super.setPrettyPrint(bl);
        }

        public GetCertForOpenIdConnect setQuotaUser(String string) {
            return (GetCertForOpenIdConnect)super.setQuotaUser(string);
        }

        public GetCertForOpenIdConnect setUserIp(String string) {
            return (GetCertForOpenIdConnect)super.setUserIp(string);
        }

        @Override
        public GetCertForOpenIdConnect set(String string, Object object) {
            return (GetCertForOpenIdConnect)super.set(string, object);
        }
    }

    public class Userinfo {
        public Get get() throws IOException {
            Get get = new Get();
            Oauth2.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public V2 v2() {
            return new V2();
        }

        public class V2 {
            public Me me() {
                return new Me();
            }

            public class Me {
                public Get get() throws IOException {
                    Get get = new Get();
                    Oauth2.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends Oauth2Request<Userinfoplus> {
                    private static final String REST_PATH = "userinfo/v2/me";

                    protected Get() {
                        super(Oauth2.this, "GET", REST_PATH, null, Userinfoplus.class);
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUserIp(String string) {
                        return (Get)super.setUserIp(string);
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends Oauth2Request<Userinfoplus> {
            private static final String REST_PATH = "oauth2/v1/userinfo";

            protected Get() {
                super(Oauth2.this, "GET", REST_PATH, null, Userinfoplus.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

