/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Updates the TableRowStyle of rows in a table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateTableRowStyleRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableRowStyle` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update the minimum row height, set `fields` to
   * `"min_row_height"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The list of zero-based row indices whose style should be updated. If no indices are specified,
   * all rows will be updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Integer> rowIndices;

  /**
   * The styles to be set on the rows.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableRowStyle tableRowStyle;

  /**
   * The location where the table starts in the document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location tableStartLocation;

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableRowStyle` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update the minimum row height, set `fields` to
   * `"min_row_height"`.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableRowStyle` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update the minimum row height, set `fields` to
   * `"min_row_height"`.
   * @param fields fields or {@code null} for none
   */
  public UpdateTableRowStyleRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The list of zero-based row indices whose style should be updated. If no indices are specified,
   * all rows will be updated.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Integer> getRowIndices() {
    return rowIndices;
  }

  /**
   * The list of zero-based row indices whose style should be updated. If no indices are specified,
   * all rows will be updated.
   * @param rowIndices rowIndices or {@code null} for none
   */
  public UpdateTableRowStyleRequest setRowIndices(java.util.List<java.lang.Integer> rowIndices) {
    this.rowIndices = rowIndices;
    return this;
  }

  /**
   * The styles to be set on the rows.
   * @return value or {@code null} for none
   */
  public TableRowStyle getTableRowStyle() {
    return tableRowStyle;
  }

  /**
   * The styles to be set on the rows.
   * @param tableRowStyle tableRowStyle or {@code null} for none
   */
  public UpdateTableRowStyleRequest setTableRowStyle(TableRowStyle tableRowStyle) {
    this.tableRowStyle = tableRowStyle;
    return this;
  }

  /**
   * The location where the table starts in the document.
   * @return value or {@code null} for none
   */
  public Location getTableStartLocation() {
    return tableStartLocation;
  }

  /**
   * The location where the table starts in the document.
   * @param tableStartLocation tableStartLocation or {@code null} for none
   */
  public UpdateTableRowStyleRequest setTableStartLocation(Location tableStartLocation) {
    this.tableStartLocation = tableStartLocation;
    return this;
  }

  @Override
  public UpdateTableRowStyleRequest set(String fieldName, Object value) {
    return (UpdateTableRowStyleRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateTableRowStyleRequest clone() {
    return (UpdateTableRowStyleRequest) super.clone();
  }

}
