/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Updates the TableColumnProperties of columns in a table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateTableColumnPropertiesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The list of zero-based column indices whose property should be updated. If no indices are
   * specified, all columns will be updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Integer> columnIndices;

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableColumnProperties` is implied and should not be specified. A single `"*"` can be used as
   * short-hand for listing every field. For example to update the column width, set `fields` to
   * `"width"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The table column properties to update. If the value of `table_column_properties#width` is less
   * than 5 points (5/72 inch), a 400 bad request error is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableColumnProperties tableColumnProperties;

  /**
   * The location where the table starts in the document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location tableStartLocation;

  /**
   * The list of zero-based column indices whose property should be updated. If no indices are
   * specified, all columns will be updated.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Integer> getColumnIndices() {
    return columnIndices;
  }

  /**
   * The list of zero-based column indices whose property should be updated. If no indices are
   * specified, all columns will be updated.
   * @param columnIndices columnIndices or {@code null} for none
   */
  public UpdateTableColumnPropertiesRequest setColumnIndices(java.util.List<java.lang.Integer> columnIndices) {
    this.columnIndices = columnIndices;
    return this;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableColumnProperties` is implied and should not be specified. A single `"*"` can be used as
   * short-hand for listing every field. For example to update the column width, set `fields` to
   * `"width"`.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableColumnProperties` is implied and should not be specified. A single `"*"` can be used as
   * short-hand for listing every field. For example to update the column width, set `fields` to
   * `"width"`.
   * @param fields fields or {@code null} for none
   */
  public UpdateTableColumnPropertiesRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The table column properties to update. If the value of `table_column_properties#width` is less
   * than 5 points (5/72 inch), a 400 bad request error is returned.
   * @return value or {@code null} for none
   */
  public TableColumnProperties getTableColumnProperties() {
    return tableColumnProperties;
  }

  /**
   * The table column properties to update. If the value of `table_column_properties#width` is less
   * than 5 points (5/72 inch), a 400 bad request error is returned.
   * @param tableColumnProperties tableColumnProperties or {@code null} for none
   */
  public UpdateTableColumnPropertiesRequest setTableColumnProperties(TableColumnProperties tableColumnProperties) {
    this.tableColumnProperties = tableColumnProperties;
    return this;
  }

  /**
   * The location where the table starts in the document.
   * @return value or {@code null} for none
   */
  public Location getTableStartLocation() {
    return tableStartLocation;
  }

  /**
   * The location where the table starts in the document.
   * @param tableStartLocation tableStartLocation or {@code null} for none
   */
  public UpdateTableColumnPropertiesRequest setTableStartLocation(Location tableStartLocation) {
    this.tableStartLocation = tableStartLocation;
    return this;
  }

  @Override
  public UpdateTableColumnPropertiesRequest set(String fieldName, Object value) {
    return (UpdateTableColumnPropertiesRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateTableColumnPropertiesRequest clone() {
    return (UpdateTableColumnPropertiesRequest) super.clone();
  }

}
