/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Updates the SectionStyle.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateSectionStyleRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `section_style` is implied and must not be specified. A single `"*"` can be used as short-hand
   * for listing every field. For example to update the left margin, set `fields` to
   * `"margin_left"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The range overlapping the sections to style. Because section breaks can only be inserted inside
   * the body, the segment ID field must be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Range range;

  /**
   * The styles to be set on the section. Certain section style changes may cause other changes in
   * order to mirror the behavior of the Docs editor. See the documentation of SectionStyle for more
   * information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SectionStyle sectionStyle;

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `section_style` is implied and must not be specified. A single `"*"` can be used as short-hand
   * for listing every field. For example to update the left margin, set `fields` to
   * `"margin_left"`.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `section_style` is implied and must not be specified. A single `"*"` can be used as short-hand
   * for listing every field. For example to update the left margin, set `fields` to
   * `"margin_left"`.
   * @param fields fields or {@code null} for none
   */
  public UpdateSectionStyleRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The range overlapping the sections to style. Because section breaks can only be inserted inside
   * the body, the segment ID field must be empty.
   * @return value or {@code null} for none
   */
  public Range getRange() {
    return range;
  }

  /**
   * The range overlapping the sections to style. Because section breaks can only be inserted inside
   * the body, the segment ID field must be empty.
   * @param range range or {@code null} for none
   */
  public UpdateSectionStyleRequest setRange(Range range) {
    this.range = range;
    return this;
  }

  /**
   * The styles to be set on the section. Certain section style changes may cause other changes in
   * order to mirror the behavior of the Docs editor. See the documentation of SectionStyle for more
   * information.
   * @return value or {@code null} for none
   */
  public SectionStyle getSectionStyle() {
    return sectionStyle;
  }

  /**
   * The styles to be set on the section. Certain section style changes may cause other changes in
   * order to mirror the behavior of the Docs editor. See the documentation of SectionStyle for more
   * information.
   * @param sectionStyle sectionStyle or {@code null} for none
   */
  public UpdateSectionStyleRequest setSectionStyle(SectionStyle sectionStyle) {
    this.sectionStyle = sectionStyle;
    return this;
  }

  @Override
  public UpdateSectionStyleRequest set(String fieldName, Object value) {
    return (UpdateSectionStyleRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateSectionStyleRequest clone() {
    return (UpdateSectionStyleRequest) super.clone();
  }

}
