/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Updates the DocumentStyle.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateDocumentStyleRequest extends com.google.api.client.json.GenericJson {

  /**
   * The styles to set on the document. Certain document style changes may cause other changes in
   * order to mirror the behavior of the Docs editor. See the documentation of DocumentStyle for
   * more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DocumentStyle documentStyle;

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `document_style` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update the background, set `fields` to
   * `"background"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The tab that contains the style to update. When omitted, the request applies to the first tab.
   * In a document containing a single tab: - If provided, must match the singular tab's ID. - If
   * omitted, the request applies to the singular tab. In a document containing multiple tabs: - If
   * provided, the request applies to the specified tab. - If not provided, the request applies to
   * the first tab in the document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tabId;

  /**
   * The styles to set on the document. Certain document style changes may cause other changes in
   * order to mirror the behavior of the Docs editor. See the documentation of DocumentStyle for
   * more information.
   * @return value or {@code null} for none
   */
  public DocumentStyle getDocumentStyle() {
    return documentStyle;
  }

  /**
   * The styles to set on the document. Certain document style changes may cause other changes in
   * order to mirror the behavior of the Docs editor. See the documentation of DocumentStyle for
   * more information.
   * @param documentStyle documentStyle or {@code null} for none
   */
  public UpdateDocumentStyleRequest setDocumentStyle(DocumentStyle documentStyle) {
    this.documentStyle = documentStyle;
    return this;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `document_style` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update the background, set `fields` to
   * `"background"`.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `document_style` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update the background, set `fields` to
   * `"background"`.
   * @param fields fields or {@code null} for none
   */
  public UpdateDocumentStyleRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The tab that contains the style to update. When omitted, the request applies to the first tab.
   * In a document containing a single tab: - If provided, must match the singular tab's ID. - If
   * omitted, the request applies to the singular tab. In a document containing multiple tabs: - If
   * provided, the request applies to the specified tab. - If not provided, the request applies to
   * the first tab in the document.
   * @return value or {@code null} for none
   */
  public java.lang.String getTabId() {
    return tabId;
  }

  /**
   * The tab that contains the style to update. When omitted, the request applies to the first tab.
   * In a document containing a single tab: - If provided, must match the singular tab's ID. - If
   * omitted, the request applies to the singular tab. In a document containing multiple tabs: - If
   * provided, the request applies to the specified tab. - If not provided, the request applies to
   * the first tab in the document.
   * @param tabId tabId or {@code null} for none
   */
  public UpdateDocumentStyleRequest setTabId(java.lang.String tabId) {
    this.tabId = tabId;
    return this;
  }

  @Override
  public UpdateDocumentStyleRequest set(String fieldName, Object value) {
    return (UpdateDocumentStyleRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateDocumentStyleRequest clone() {
    return (UpdateDocumentStyleRequest) super.clone();
  }

}
