/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Unmerges cells in a Table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UnmergeTableCellsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The table range specifying which cells of the table to unmerge. All merged cells in this range
   * will be unmerged, and cells that are already unmerged will not be affected. If the range has no
   * merged cells, the request will do nothing. If there is text in any of the merged cells, the
   * text will remain in the "head" cell of the resulting block of unmerged cells. The "head" cell
   * is the upper-left cell when the content direction is from left to right, and the upper-right
   * otherwise.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableRange tableRange;

  /**
   * The table range specifying which cells of the table to unmerge. All merged cells in this range
   * will be unmerged, and cells that are already unmerged will not be affected. If the range has no
   * merged cells, the request will do nothing. If there is text in any of the merged cells, the
   * text will remain in the "head" cell of the resulting block of unmerged cells. The "head" cell
   * is the upper-left cell when the content direction is from left to right, and the upper-right
   * otherwise.
   * @return value or {@code null} for none
   */
  public TableRange getTableRange() {
    return tableRange;
  }

  /**
   * The table range specifying which cells of the table to unmerge. All merged cells in this range
   * will be unmerged, and cells that are already unmerged will not be affected. If the range has no
   * merged cells, the request will do nothing. If there is text in any of the merged cells, the
   * text will remain in the "head" cell of the resulting block of unmerged cells. The "head" cell
   * is the upper-left cell when the content direction is from left to right, and the upper-right
   * otherwise.
   * @param tableRange tableRange or {@code null} for none
   */
  public UnmergeTableCellsRequest setTableRange(TableRange tableRange) {
    this.tableRange = tableRange;
    return this;
  }

  @Override
  public UnmergeTableCellsRequest set(String fieldName, Object value) {
    return (UnmergeTableCellsRequest) super.set(fieldName, value);
  }

  @Override
  public UnmergeTableCellsRequest clone() {
    return (UnmergeTableCellsRequest) super.clone();
  }

}
