/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Styles that apply to a table row.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableRowStyle extends com.google.api.client.json.GenericJson {

  /**
   * The minimum height of the row. The row will be rendered in the Docs editor at a height equal to
   * or greater than this value in order to show all the content in the row's cells.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension minRowHeight;

  /**
   * Whether the row cannot overflow across page or column boundaries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean preventOverflow;

  /**
   * Whether the row is a table header.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean tableHeader;

  /**
   * The minimum height of the row. The row will be rendered in the Docs editor at a height equal to
   * or greater than this value in order to show all the content in the row's cells.
   * @return value or {@code null} for none
   */
  public Dimension getMinRowHeight() {
    return minRowHeight;
  }

  /**
   * The minimum height of the row. The row will be rendered in the Docs editor at a height equal to
   * or greater than this value in order to show all the content in the row's cells.
   * @param minRowHeight minRowHeight or {@code null} for none
   */
  public TableRowStyle setMinRowHeight(Dimension minRowHeight) {
    this.minRowHeight = minRowHeight;
    return this;
  }

  /**
   * Whether the row cannot overflow across page or column boundaries.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPreventOverflow() {
    return preventOverflow;
  }

  /**
   * Whether the row cannot overflow across page or column boundaries.
   * @param preventOverflow preventOverflow or {@code null} for none
   */
  public TableRowStyle setPreventOverflow(java.lang.Boolean preventOverflow) {
    this.preventOverflow = preventOverflow;
    return this;
  }

  /**
   * Whether the row is a table header.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTableHeader() {
    return tableHeader;
  }

  /**
   * Whether the row is a table header.
   * @param tableHeader tableHeader or {@code null} for none
   */
  public TableRowStyle setTableHeader(java.lang.Boolean tableHeader) {
    this.tableHeader = tableHeader;
    return this;
  }

  @Override
  public TableRowStyle set(String fieldName, Object value) {
    return (TableRowStyle) super.set(fieldName, value);
  }

  @Override
  public TableRowStyle clone() {
    return (TableRowStyle) super.clone();
  }

}
