/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A StructuralElement representing a table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Table extends com.google.api.client.json.GenericJson {

  /**
   * Number of columns in the table. It's possible for a table to be non-rectangular, so some rows
   * may have a different number of cells.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer columns;

  /**
   * Number of rows in the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer rows;

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> suggestedDeletionIds;

  /**
   * The suggested insertion IDs. A Table may have multiple insertion IDs if it's a nested suggested
   * change. If empty, then this is not a suggested insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> suggestedInsertionIds;

  /**
   * The contents and style of each row.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TableRow> tableRows;

  /**
   * The style of the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableStyle tableStyle;

  /**
   * Number of columns in the table. It's possible for a table to be non-rectangular, so some rows
   * may have a different number of cells.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getColumns() {
    return columns;
  }

  /**
   * Number of columns in the table. It's possible for a table to be non-rectangular, so some rows
   * may have a different number of cells.
   * @param columns columns or {@code null} for none
   */
  public Table setColumns(java.lang.Integer columns) {
    this.columns = columns;
    return this;
  }

  /**
   * Number of rows in the table.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRows() {
    return rows;
  }

  /**
   * Number of rows in the table.
   * @param rows rows or {@code null} for none
   */
  public Table setRows(java.lang.Integer rows) {
    this.rows = rows;
    return this;
  }

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSuggestedDeletionIds() {
    return suggestedDeletionIds;
  }

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * @param suggestedDeletionIds suggestedDeletionIds or {@code null} for none
   */
  public Table setSuggestedDeletionIds(java.util.List<java.lang.String> suggestedDeletionIds) {
    this.suggestedDeletionIds = suggestedDeletionIds;
    return this;
  }

  /**
   * The suggested insertion IDs. A Table may have multiple insertion IDs if it's a nested suggested
   * change. If empty, then this is not a suggested insertion.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSuggestedInsertionIds() {
    return suggestedInsertionIds;
  }

  /**
   * The suggested insertion IDs. A Table may have multiple insertion IDs if it's a nested suggested
   * change. If empty, then this is not a suggested insertion.
   * @param suggestedInsertionIds suggestedInsertionIds or {@code null} for none
   */
  public Table setSuggestedInsertionIds(java.util.List<java.lang.String> suggestedInsertionIds) {
    this.suggestedInsertionIds = suggestedInsertionIds;
    return this;
  }

  /**
   * The contents and style of each row.
   * @return value or {@code null} for none
   */
  public java.util.List<TableRow> getTableRows() {
    return tableRows;
  }

  /**
   * The contents and style of each row.
   * @param tableRows tableRows or {@code null} for none
   */
  public Table setTableRows(java.util.List<TableRow> tableRows) {
    this.tableRows = tableRows;
    return this;
  }

  /**
   * The style of the table.
   * @return value or {@code null} for none
   */
  public TableStyle getTableStyle() {
    return tableStyle;
  }

  /**
   * The style of the table.
   * @param tableStyle tableStyle or {@code null} for none
   */
  public Table setTableStyle(TableStyle tableStyle) {
    this.tableStyle = tableStyle;
    return this;
  }

  @Override
  public Table set(String fieldName, Object value) {
    return (Table) super.set(fieldName, value);
  }

  @Override
  public Table clone() {
    return (Table) super.clone();
  }

}
