/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A suggested change to a TextStyle.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SuggestedTextStyle extends com.google.api.client.json.GenericJson {

  /**
   * A TextStyle that only includes the changes made in this suggestion. This can be used along with
   * the text_style_suggestion_state to see which fields have changed and their new values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextStyle textStyle;

  /**
   * A mask that indicates which of the fields on the base TextStyle have been changed in this
   * suggestion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextStyleSuggestionState textStyleSuggestionState;

  /**
   * A TextStyle that only includes the changes made in this suggestion. This can be used along with
   * the text_style_suggestion_state to see which fields have changed and their new values.
   * @return value or {@code null} for none
   */
  public TextStyle getTextStyle() {
    return textStyle;
  }

  /**
   * A TextStyle that only includes the changes made in this suggestion. This can be used along with
   * the text_style_suggestion_state to see which fields have changed and their new values.
   * @param textStyle textStyle or {@code null} for none
   */
  public SuggestedTextStyle setTextStyle(TextStyle textStyle) {
    this.textStyle = textStyle;
    return this;
  }

  /**
   * A mask that indicates which of the fields on the base TextStyle have been changed in this
   * suggestion.
   * @return value or {@code null} for none
   */
  public TextStyleSuggestionState getTextStyleSuggestionState() {
    return textStyleSuggestionState;
  }

  /**
   * A mask that indicates which of the fields on the base TextStyle have been changed in this
   * suggestion.
   * @param textStyleSuggestionState textStyleSuggestionState or {@code null} for none
   */
  public SuggestedTextStyle setTextStyleSuggestionState(TextStyleSuggestionState textStyleSuggestionState) {
    this.textStyleSuggestionState = textStyleSuggestionState;
    return this;
  }

  @Override
  public SuggestedTextStyle set(String fieldName, Object value) {
    return (SuggestedTextStyle) super.set(fieldName, value);
  }

  @Override
  public SuggestedTextStyle clone() {
    return (SuggestedTextStyle) super.clone();
  }

}
