/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A StructuralElement describes content that provides structure to the document.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StructuralElement extends com.google.api.client.json.GenericJson {

  /**
   * The zero-based end index of this structural element, exclusive, in UTF-16 code units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer endIndex;

  /**
   * A paragraph type of structural element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Paragraph paragraph;

  /**
   * A section break type of structural element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SectionBreak sectionBreak;

  /**
   * The zero-based start index of this structural element, in UTF-16 code units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * A table type of structural element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Table table;

  /**
   * A table of contents type of structural element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableOfContents tableOfContents;

  /**
   * The zero-based end index of this structural element, exclusive, in UTF-16 code units.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEndIndex() {
    return endIndex;
  }

  /**
   * The zero-based end index of this structural element, exclusive, in UTF-16 code units.
   * @param endIndex endIndex or {@code null} for none
   */
  public StructuralElement setEndIndex(java.lang.Integer endIndex) {
    this.endIndex = endIndex;
    return this;
  }

  /**
   * A paragraph type of structural element.
   * @return value or {@code null} for none
   */
  public Paragraph getParagraph() {
    return paragraph;
  }

  /**
   * A paragraph type of structural element.
   * @param paragraph paragraph or {@code null} for none
   */
  public StructuralElement setParagraph(Paragraph paragraph) {
    this.paragraph = paragraph;
    return this;
  }

  /**
   * A section break type of structural element.
   * @return value or {@code null} for none
   */
  public SectionBreak getSectionBreak() {
    return sectionBreak;
  }

  /**
   * A section break type of structural element.
   * @param sectionBreak sectionBreak or {@code null} for none
   */
  public StructuralElement setSectionBreak(SectionBreak sectionBreak) {
    this.sectionBreak = sectionBreak;
    return this;
  }

  /**
   * The zero-based start index of this structural element, in UTF-16 code units.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The zero-based start index of this structural element, in UTF-16 code units.
   * @param startIndex startIndex or {@code null} for none
   */
  public StructuralElement setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * A table type of structural element.
   * @return value or {@code null} for none
   */
  public Table getTable() {
    return table;
  }

  /**
   * A table type of structural element.
   * @param table table or {@code null} for none
   */
  public StructuralElement setTable(Table table) {
    this.table = table;
    return this;
  }

  /**
   * A table of contents type of structural element.
   * @return value or {@code null} for none
   */
  public TableOfContents getTableOfContents() {
    return tableOfContents;
  }

  /**
   * A table of contents type of structural element.
   * @param tableOfContents tableOfContents or {@code null} for none
   */
  public StructuralElement setTableOfContents(TableOfContents tableOfContents) {
    this.tableOfContents = tableOfContents;
    return this;
  }

  @Override
  public StructuralElement set(String fieldName, Object value) {
    return (StructuralElement) super.set(fieldName, value);
  }

  @Override
  public StructuralElement clone() {
    return (StructuralElement) super.clone();
  }

}
