/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Properties that apply to a section's column.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SectionColumnProperties extends com.google.api.client.json.GenericJson {

  /**
   * The padding at the end of the column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension paddingEnd;

  /**
   * Output only. The width of the column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension width;

  /**
   * The padding at the end of the column.
   * @return value or {@code null} for none
   */
  public Dimension getPaddingEnd() {
    return paddingEnd;
  }

  /**
   * The padding at the end of the column.
   * @param paddingEnd paddingEnd or {@code null} for none
   */
  public SectionColumnProperties setPaddingEnd(Dimension paddingEnd) {
    this.paddingEnd = paddingEnd;
    return this;
  }

  /**
   * Output only. The width of the column.
   * @return value or {@code null} for none
   */
  public Dimension getWidth() {
    return width;
  }

  /**
   * Output only. The width of the column.
   * @param width width or {@code null} for none
   */
  public SectionColumnProperties setWidth(Dimension width) {
    this.width = width;
    return this;
  }

  @Override
  public SectionColumnProperties set(String fieldName, Object value) {
    return (SectionColumnProperties) super.set(fieldName, value);
  }

  @Override
  public SectionColumnProperties clone() {
    return (SectionColumnProperties) super.clone();
  }

}
