/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A single response from an update.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Response extends com.google.api.client.json.GenericJson {

  /**
   * The result of creating a footer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateFooterResponse createFooter;

  /**
   * The result of creating a footnote.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateFootnoteResponse createFootnote;

  /**
   * The result of creating a header.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateHeaderResponse createHeader;

  /**
   * The result of creating a named range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateNamedRangeResponse createNamedRange;

  /**
   * The result of inserting an inline image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InsertInlineImageResponse insertInlineImage;

  /**
   * The result of inserting an inline Google Sheets chart.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InsertInlineSheetsChartResponse insertInlineSheetsChart;

  /**
   * The result of replacing text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReplaceAllTextResponse replaceAllText;

  /**
   * The result of creating a footer.
   * @return value or {@code null} for none
   */
  public CreateFooterResponse getCreateFooter() {
    return createFooter;
  }

  /**
   * The result of creating a footer.
   * @param createFooter createFooter or {@code null} for none
   */
  public Response setCreateFooter(CreateFooterResponse createFooter) {
    this.createFooter = createFooter;
    return this;
  }

  /**
   * The result of creating a footnote.
   * @return value or {@code null} for none
   */
  public CreateFootnoteResponse getCreateFootnote() {
    return createFootnote;
  }

  /**
   * The result of creating a footnote.
   * @param createFootnote createFootnote or {@code null} for none
   */
  public Response setCreateFootnote(CreateFootnoteResponse createFootnote) {
    this.createFootnote = createFootnote;
    return this;
  }

  /**
   * The result of creating a header.
   * @return value or {@code null} for none
   */
  public CreateHeaderResponse getCreateHeader() {
    return createHeader;
  }

  /**
   * The result of creating a header.
   * @param createHeader createHeader or {@code null} for none
   */
  public Response setCreateHeader(CreateHeaderResponse createHeader) {
    this.createHeader = createHeader;
    return this;
  }

  /**
   * The result of creating a named range.
   * @return value or {@code null} for none
   */
  public CreateNamedRangeResponse getCreateNamedRange() {
    return createNamedRange;
  }

  /**
   * The result of creating a named range.
   * @param createNamedRange createNamedRange or {@code null} for none
   */
  public Response setCreateNamedRange(CreateNamedRangeResponse createNamedRange) {
    this.createNamedRange = createNamedRange;
    return this;
  }

  /**
   * The result of inserting an inline image.
   * @return value or {@code null} for none
   */
  public InsertInlineImageResponse getInsertInlineImage() {
    return insertInlineImage;
  }

  /**
   * The result of inserting an inline image.
   * @param insertInlineImage insertInlineImage or {@code null} for none
   */
  public Response setInsertInlineImage(InsertInlineImageResponse insertInlineImage) {
    this.insertInlineImage = insertInlineImage;
    return this;
  }

  /**
   * The result of inserting an inline Google Sheets chart.
   * @return value or {@code null} for none
   */
  public InsertInlineSheetsChartResponse getInsertInlineSheetsChart() {
    return insertInlineSheetsChart;
  }

  /**
   * The result of inserting an inline Google Sheets chart.
   * @param insertInlineSheetsChart insertInlineSheetsChart or {@code null} for none
   */
  public Response setInsertInlineSheetsChart(InsertInlineSheetsChartResponse insertInlineSheetsChart) {
    this.insertInlineSheetsChart = insertInlineSheetsChart;
    return this;
  }

  /**
   * The result of replacing text.
   * @return value or {@code null} for none
   */
  public ReplaceAllTextResponse getReplaceAllText() {
    return replaceAllText;
  }

  /**
   * The result of replacing text.
   * @param replaceAllText replaceAllText or {@code null} for none
   */
  public Response setReplaceAllText(ReplaceAllTextResponse replaceAllText) {
    this.replaceAllText = replaceAllText;
    return this;
  }

  @Override
  public Response set(String fieldName, Object value) {
    return (Response) super.set(fieldName, value);
  }

  @Override
  public Response clone() {
    return (Response) super.clone();
  }

}
