/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * The positioning of a PositionedObject. The positioned object is positioned relative to the
 * beginning of the Paragraph it's tethered to.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PositionedObjectPositioning extends com.google.api.client.json.GenericJson {

  /**
   * The layout of this positioned object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String layout;

  /**
   * The offset of the left edge of the positioned object relative to the beginning of the Paragraph
   * it's tethered to. The exact positioning of the object can depend on other content in the
   * document and the document's styling.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension leftOffset;

  /**
   * The offset of the top edge of the positioned object relative to the beginning of the Paragraph
   * it's tethered to. The exact positioning of the object can depend on other content in the
   * document and the document's styling.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension topOffset;

  /**
   * The layout of this positioned object.
   * @return value or {@code null} for none
   */
  public java.lang.String getLayout() {
    return layout;
  }

  /**
   * The layout of this positioned object.
   * @param layout layout or {@code null} for none
   */
  public PositionedObjectPositioning setLayout(java.lang.String layout) {
    this.layout = layout;
    return this;
  }

  /**
   * The offset of the left edge of the positioned object relative to the beginning of the Paragraph
   * it's tethered to. The exact positioning of the object can depend on other content in the
   * document and the document's styling.
   * @return value or {@code null} for none
   */
  public Dimension getLeftOffset() {
    return leftOffset;
  }

  /**
   * The offset of the left edge of the positioned object relative to the beginning of the Paragraph
   * it's tethered to. The exact positioning of the object can depend on other content in the
   * document and the document's styling.
   * @param leftOffset leftOffset or {@code null} for none
   */
  public PositionedObjectPositioning setLeftOffset(Dimension leftOffset) {
    this.leftOffset = leftOffset;
    return this;
  }

  /**
   * The offset of the top edge of the positioned object relative to the beginning of the Paragraph
   * it's tethered to. The exact positioning of the object can depend on other content in the
   * document and the document's styling.
   * @return value or {@code null} for none
   */
  public Dimension getTopOffset() {
    return topOffset;
  }

  /**
   * The offset of the top edge of the positioned object relative to the beginning of the Paragraph
   * it's tethered to. The exact positioning of the object can depend on other content in the
   * document and the document's styling.
   * @param topOffset topOffset or {@code null} for none
   */
  public PositionedObjectPositioning setTopOffset(Dimension topOffset) {
    this.topOffset = topOffset;
    return this;
  }

  @Override
  public PositionedObjectPositioning set(String fieldName, Object value) {
    return (PositionedObjectPositioning) super.set(fieldName, value);
  }

  @Override
  public PositionedObjectPositioning clone() {
    return (PositionedObjectPositioning) super.clone();
  }

}
