/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * An object that's tethered to a Paragraph and positioned relative to the beginning of the
 * paragraph. A PositionedObject contains an EmbeddedObject such as an image.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PositionedObject extends com.google.api.client.json.GenericJson {

  /**
   * The ID of this positioned object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The properties of this positioned object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PositionedObjectProperties positionedObjectProperties;

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> suggestedDeletionIds;

  /**
   * The suggested insertion ID. If empty, then this is not a suggested insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String suggestedInsertionId;

  /**
   * The suggested changes to the positioned object properties, keyed by suggestion ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, SuggestedPositionedObjectProperties> suggestedPositionedObjectPropertiesChanges;

  /**
   * The ID of this positioned object.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The ID of this positioned object.
   * @param objectId objectId or {@code null} for none
   */
  public PositionedObject setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The properties of this positioned object.
   * @return value or {@code null} for none
   */
  public PositionedObjectProperties getPositionedObjectProperties() {
    return positionedObjectProperties;
  }

  /**
   * The properties of this positioned object.
   * @param positionedObjectProperties positionedObjectProperties or {@code null} for none
   */
  public PositionedObject setPositionedObjectProperties(PositionedObjectProperties positionedObjectProperties) {
    this.positionedObjectProperties = positionedObjectProperties;
    return this;
  }

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSuggestedDeletionIds() {
    return suggestedDeletionIds;
  }

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * @param suggestedDeletionIds suggestedDeletionIds or {@code null} for none
   */
  public PositionedObject setSuggestedDeletionIds(java.util.List<java.lang.String> suggestedDeletionIds) {
    this.suggestedDeletionIds = suggestedDeletionIds;
    return this;
  }

  /**
   * The suggested insertion ID. If empty, then this is not a suggested insertion.
   * @return value or {@code null} for none
   */
  public java.lang.String getSuggestedInsertionId() {
    return suggestedInsertionId;
  }

  /**
   * The suggested insertion ID. If empty, then this is not a suggested insertion.
   * @param suggestedInsertionId suggestedInsertionId or {@code null} for none
   */
  public PositionedObject setSuggestedInsertionId(java.lang.String suggestedInsertionId) {
    this.suggestedInsertionId = suggestedInsertionId;
    return this;
  }

  /**
   * The suggested changes to the positioned object properties, keyed by suggestion ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, SuggestedPositionedObjectProperties> getSuggestedPositionedObjectPropertiesChanges() {
    return suggestedPositionedObjectPropertiesChanges;
  }

  /**
   * The suggested changes to the positioned object properties, keyed by suggestion ID.
   * @param suggestedPositionedObjectPropertiesChanges suggestedPositionedObjectPropertiesChanges or {@code null} for none
   */
  public PositionedObject setSuggestedPositionedObjectPropertiesChanges(java.util.Map<String, SuggestedPositionedObjectProperties> suggestedPositionedObjectPropertiesChanges) {
    this.suggestedPositionedObjectPropertiesChanges = suggestedPositionedObjectPropertiesChanges;
    return this;
  }

  @Override
  public PositionedObject set(String fieldName, Object value) {
    return (PositionedObject) super.set(fieldName, value);
  }

  @Override
  public PositionedObject clone() {
    return (PositionedObject) super.clone();
  }

}
