/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Updates the number of pinned table header rows in a table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PinTableHeaderRowsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The number of table rows to pin, where 0 implies that all rows are unpinned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer pinnedHeaderRowsCount;

  /**
   * The location where the table starts in the document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location tableStartLocation;

  /**
   * The number of table rows to pin, where 0 implies that all rows are unpinned.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPinnedHeaderRowsCount() {
    return pinnedHeaderRowsCount;
  }

  /**
   * The number of table rows to pin, where 0 implies that all rows are unpinned.
   * @param pinnedHeaderRowsCount pinnedHeaderRowsCount or {@code null} for none
   */
  public PinTableHeaderRowsRequest setPinnedHeaderRowsCount(java.lang.Integer pinnedHeaderRowsCount) {
    this.pinnedHeaderRowsCount = pinnedHeaderRowsCount;
    return this;
  }

  /**
   * The location where the table starts in the document.
   * @return value or {@code null} for none
   */
  public Location getTableStartLocation() {
    return tableStartLocation;
  }

  /**
   * The location where the table starts in the document.
   * @param tableStartLocation tableStartLocation or {@code null} for none
   */
  public PinTableHeaderRowsRequest setTableStartLocation(Location tableStartLocation) {
    this.tableStartLocation = tableStartLocation;
    return this;
  }

  @Override
  public PinTableHeaderRowsRequest set(String fieldName, Object value) {
    return (PinTableHeaderRowsRequest) super.set(fieldName, value);
  }

  @Override
  public PinTableHeaderRowsRequest clone() {
    return (PinTableHeaderRowsRequest) super.clone();
  }

}
