/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A person or email address mentioned in a document. These mentions behave as a single, immutable
 * element containing the person's name or email address.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Person extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The unique ID of this link.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String personId;

  /**
   * Output only. The properties of this Person. This field is always present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PersonProperties personProperties;

  /**
   * IDs for suggestions that remove this person link from the document. A Person might have
   * multiple deletion IDs if, for example, multiple users suggest deleting it. If empty, then this
   * person link isn't suggested for deletion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> suggestedDeletionIds;

  /**
   * IDs for suggestions that insert this person link into the document. A Person might have
   * multiple insertion IDs if it's a nested suggested change (a suggestion within a suggestion made
   * by a different user, for example). If empty, then this person link isn't a suggested insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> suggestedInsertionIds;

  /**
   * The suggested text style changes to this Person, keyed by suggestion ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, SuggestedTextStyle> suggestedTextStyleChanges;

  /**
   * The text style of this Person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextStyle textStyle;

  /**
   * Output only. The unique ID of this link.
   * @return value or {@code null} for none
   */
  public java.lang.String getPersonId() {
    return personId;
  }

  /**
   * Output only. The unique ID of this link.
   * @param personId personId or {@code null} for none
   */
  public Person setPersonId(java.lang.String personId) {
    this.personId = personId;
    return this;
  }

  /**
   * Output only. The properties of this Person. This field is always present.
   * @return value or {@code null} for none
   */
  public PersonProperties getPersonProperties() {
    return personProperties;
  }

  /**
   * Output only. The properties of this Person. This field is always present.
   * @param personProperties personProperties or {@code null} for none
   */
  public Person setPersonProperties(PersonProperties personProperties) {
    this.personProperties = personProperties;
    return this;
  }

  /**
   * IDs for suggestions that remove this person link from the document. A Person might have
   * multiple deletion IDs if, for example, multiple users suggest deleting it. If empty, then this
   * person link isn't suggested for deletion.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSuggestedDeletionIds() {
    return suggestedDeletionIds;
  }

  /**
   * IDs for suggestions that remove this person link from the document. A Person might have
   * multiple deletion IDs if, for example, multiple users suggest deleting it. If empty, then this
   * person link isn't suggested for deletion.
   * @param suggestedDeletionIds suggestedDeletionIds or {@code null} for none
   */
  public Person setSuggestedDeletionIds(java.util.List<java.lang.String> suggestedDeletionIds) {
    this.suggestedDeletionIds = suggestedDeletionIds;
    return this;
  }

  /**
   * IDs for suggestions that insert this person link into the document. A Person might have
   * multiple insertion IDs if it's a nested suggested change (a suggestion within a suggestion made
   * by a different user, for example). If empty, then this person link isn't a suggested insertion.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSuggestedInsertionIds() {
    return suggestedInsertionIds;
  }

  /**
   * IDs for suggestions that insert this person link into the document. A Person might have
   * multiple insertion IDs if it's a nested suggested change (a suggestion within a suggestion made
   * by a different user, for example). If empty, then this person link isn't a suggested insertion.
   * @param suggestedInsertionIds suggestedInsertionIds or {@code null} for none
   */
  public Person setSuggestedInsertionIds(java.util.List<java.lang.String> suggestedInsertionIds) {
    this.suggestedInsertionIds = suggestedInsertionIds;
    return this;
  }

  /**
   * The suggested text style changes to this Person, keyed by suggestion ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, SuggestedTextStyle> getSuggestedTextStyleChanges() {
    return suggestedTextStyleChanges;
  }

  /**
   * The suggested text style changes to this Person, keyed by suggestion ID.
   * @param suggestedTextStyleChanges suggestedTextStyleChanges or {@code null} for none
   */
  public Person setSuggestedTextStyleChanges(java.util.Map<String, SuggestedTextStyle> suggestedTextStyleChanges) {
    this.suggestedTextStyleChanges = suggestedTextStyleChanges;
    return this;
  }

  /**
   * The text style of this Person.
   * @return value or {@code null} for none
   */
  public TextStyle getTextStyle() {
    return textStyle;
  }

  /**
   * The text style of this Person.
   * @param textStyle textStyle or {@code null} for none
   */
  public Person setTextStyle(TextStyle textStyle) {
    this.textStyle = textStyle;
    return this;
  }

  @Override
  public Person set(String fieldName, Object value) {
    return (Person) super.set(fieldName, value);
  }

  @Override
  public Person clone() {
    return (Person) super.clone();
  }

}
