/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A ParagraphElement describes content within a Paragraph.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ParagraphElement extends com.google.api.client.json.GenericJson {

  /**
   * An auto text paragraph element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoText autoText;

  /**
   * A column break paragraph element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColumnBreak columnBreak;

  /**
   * The zero-base end index of this paragraph element, exclusive, in UTF-16 code units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer endIndex;

  /**
   * An equation paragraph element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Equation equation;

  /**
   * A footnote reference paragraph element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FootnoteReference footnoteReference;

  /**
   * A horizontal rule paragraph element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HorizontalRule horizontalRule;

  /**
   * An inline object paragraph element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InlineObjectElement inlineObjectElement;

  /**
   * A page break paragraph element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PageBreak pageBreak;

  /**
   * A paragraph element that links to a person or email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Person person;

  /**
   * A paragraph element that links to a Google resource (such as a file in Google Drive, a YouTube
   * video, or a Calendar event.)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RichLink richLink;

  /**
   * The zero-based start index of this paragraph element, in UTF-16 code units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * A text run paragraph element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextRun textRun;

  /**
   * An auto text paragraph element.
   * @return value or {@code null} for none
   */
  public AutoText getAutoText() {
    return autoText;
  }

  /**
   * An auto text paragraph element.
   * @param autoText autoText or {@code null} for none
   */
  public ParagraphElement setAutoText(AutoText autoText) {
    this.autoText = autoText;
    return this;
  }

  /**
   * A column break paragraph element.
   * @return value or {@code null} for none
   */
  public ColumnBreak getColumnBreak() {
    return columnBreak;
  }

  /**
   * A column break paragraph element.
   * @param columnBreak columnBreak or {@code null} for none
   */
  public ParagraphElement setColumnBreak(ColumnBreak columnBreak) {
    this.columnBreak = columnBreak;
    return this;
  }

  /**
   * The zero-base end index of this paragraph element, exclusive, in UTF-16 code units.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getEndIndex() {
    return endIndex;
  }

  /**
   * The zero-base end index of this paragraph element, exclusive, in UTF-16 code units.
   * @param endIndex endIndex or {@code null} for none
   */
  public ParagraphElement setEndIndex(java.lang.Integer endIndex) {
    this.endIndex = endIndex;
    return this;
  }

  /**
   * An equation paragraph element.
   * @return value or {@code null} for none
   */
  public Equation getEquation() {
    return equation;
  }

  /**
   * An equation paragraph element.
   * @param equation equation or {@code null} for none
   */
  public ParagraphElement setEquation(Equation equation) {
    this.equation = equation;
    return this;
  }

  /**
   * A footnote reference paragraph element.
   * @return value or {@code null} for none
   */
  public FootnoteReference getFootnoteReference() {
    return footnoteReference;
  }

  /**
   * A footnote reference paragraph element.
   * @param footnoteReference footnoteReference or {@code null} for none
   */
  public ParagraphElement setFootnoteReference(FootnoteReference footnoteReference) {
    this.footnoteReference = footnoteReference;
    return this;
  }

  /**
   * A horizontal rule paragraph element.
   * @return value or {@code null} for none
   */
  public HorizontalRule getHorizontalRule() {
    return horizontalRule;
  }

  /**
   * A horizontal rule paragraph element.
   * @param horizontalRule horizontalRule or {@code null} for none
   */
  public ParagraphElement setHorizontalRule(HorizontalRule horizontalRule) {
    this.horizontalRule = horizontalRule;
    return this;
  }

  /**
   * An inline object paragraph element.
   * @return value or {@code null} for none
   */
  public InlineObjectElement getInlineObjectElement() {
    return inlineObjectElement;
  }

  /**
   * An inline object paragraph element.
   * @param inlineObjectElement inlineObjectElement or {@code null} for none
   */
  public ParagraphElement setInlineObjectElement(InlineObjectElement inlineObjectElement) {
    this.inlineObjectElement = inlineObjectElement;
    return this;
  }

  /**
   * A page break paragraph element.
   * @return value or {@code null} for none
   */
  public PageBreak getPageBreak() {
    return pageBreak;
  }

  /**
   * A page break paragraph element.
   * @param pageBreak pageBreak or {@code null} for none
   */
  public ParagraphElement setPageBreak(PageBreak pageBreak) {
    this.pageBreak = pageBreak;
    return this;
  }

  /**
   * A paragraph element that links to a person or email address.
   * @return value or {@code null} for none
   */
  public Person getPerson() {
    return person;
  }

  /**
   * A paragraph element that links to a person or email address.
   * @param person person or {@code null} for none
   */
  public ParagraphElement setPerson(Person person) {
    this.person = person;
    return this;
  }

  /**
   * A paragraph element that links to a Google resource (such as a file in Google Drive, a YouTube
   * video, or a Calendar event.)
   * @return value or {@code null} for none
   */
  public RichLink getRichLink() {
    return richLink;
  }

  /**
   * A paragraph element that links to a Google resource (such as a file in Google Drive, a YouTube
   * video, or a Calendar event.)
   * @param richLink richLink or {@code null} for none
   */
  public ParagraphElement setRichLink(RichLink richLink) {
    this.richLink = richLink;
    return this;
  }

  /**
   * The zero-based start index of this paragraph element, in UTF-16 code units.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The zero-based start index of this paragraph element, in UTF-16 code units.
   * @param startIndex startIndex or {@code null} for none
   */
  public ParagraphElement setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * A text run paragraph element.
   * @return value or {@code null} for none
   */
  public TextRun getTextRun() {
    return textRun;
  }

  /**
   * A text run paragraph element.
   * @param textRun textRun or {@code null} for none
   */
  public ParagraphElement setTextRun(TextRun textRun) {
    this.textRun = textRun;
    return this;
  }

  @Override
  public ParagraphElement set(String fieldName, Object value) {
    return (ParagraphElement) super.set(fieldName, value);
  }

  @Override
  public ParagraphElement clone() {
    return (ParagraphElement) super.clone();
  }

}
