/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Contains properties describing the look and feel of a list bullet at a given level of nesting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NestingLevel extends com.google.api.client.json.GenericJson {

  /**
   * The alignment of the bullet within the space allotted for rendering the bullet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bulletAlignment;

  /**
   * The format string used by bullets at this level of nesting. The glyph format contains one or
   * more placeholders, and these placeholders are replaced with the appropriate values depending on
   * the glyph_type or glyph_symbol. The placeholders follow the pattern `%[nesting_level]`.
   * Furthermore, placeholders can have prefixes and suffixes. Thus, the glyph format follows the
   * pattern `%[nesting_level]`. Note that the prefix and suffix are optional and can be arbitrary
   * strings. For example, the glyph format `%0.` indicates that the rendered glyph will replace the
   * placeholder with the corresponding glyph for nesting level 0 followed by a period as the
   * suffix. So a list with a glyph type of UPPER_ALPHA and glyph format `%0.` at nesting level 0
   * will result in a list with rendered glyphs `A.` `B.` `C.` The glyph format can contain
   * placeholders for the current nesting level as well as placeholders for parent nesting levels.
   * For example, a list can have a glyph format of `%0.` at nesting level 0 and a glyph format of
   * `%0.%1.` at nesting level 1. Assuming both nesting levels have DECIMAL glyph types, this would
   * result in a list with rendered glyphs `1.` `2.` ` 2.1.` ` 2.2.` `3.` For nesting levels that
   * are ordered, the string that replaces a placeholder in the glyph format for a particular
   * paragraph depends on the paragraph's order within the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String glyphFormat;

  /**
   * A custom glyph symbol used by bullets when paragraphs at this level of nesting is unordered.
   * The glyph symbol replaces placeholders within the glyph_format. For example, if the
   * glyph_symbol is the solid circle corresponding to Unicode U+25cf code point and the
   * glyph_format is `%0`, the rendered glyph would be the solid circle.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String glyphSymbol;

  /**
   * The type of glyph used by bullets when paragraphs at this level of nesting is ordered. The
   * glyph type determines the type of glyph used to replace placeholders within the glyph_format
   * when paragraphs at this level of nesting are ordered. For example, if the nesting level is 0,
   * the glyph_format is `%0.` and the glyph type is DECIMAL, then the rendered glyph would replace
   * the placeholder `%0` in the glyph format with a number corresponding to the list item's order
   * within the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String glyphType;

  /**
   * The amount of indentation for the first line of paragraphs at this level of nesting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension indentFirstLine;

  /**
   * The amount of indentation for paragraphs at this level of nesting. Applied to the side that
   * corresponds to the start of the text, based on the paragraph's content direction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension indentStart;

  /**
   * The number of the first list item at this nesting level. A value of 0 is treated as a value of
   * 1 for lettered lists and Roman numeral lists. For values of both 0 and 1, lettered and Roman
   * numeral lists will begin at `a` and `i` respectively. This value is ignored for nesting levels
   * with unordered glyphs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startNumber;

  /**
   * The text style of bullets at this level of nesting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextStyle textStyle;

  /**
   * The alignment of the bullet within the space allotted for rendering the bullet.
   * @return value or {@code null} for none
   */
  public java.lang.String getBulletAlignment() {
    return bulletAlignment;
  }

  /**
   * The alignment of the bullet within the space allotted for rendering the bullet.
   * @param bulletAlignment bulletAlignment or {@code null} for none
   */
  public NestingLevel setBulletAlignment(java.lang.String bulletAlignment) {
    this.bulletAlignment = bulletAlignment;
    return this;
  }

  /**
   * The format string used by bullets at this level of nesting. The glyph format contains one or
   * more placeholders, and these placeholders are replaced with the appropriate values depending on
   * the glyph_type or glyph_symbol. The placeholders follow the pattern `%[nesting_level]`.
   * Furthermore, placeholders can have prefixes and suffixes. Thus, the glyph format follows the
   * pattern `%[nesting_level]`. Note that the prefix and suffix are optional and can be arbitrary
   * strings. For example, the glyph format `%0.` indicates that the rendered glyph will replace the
   * placeholder with the corresponding glyph for nesting level 0 followed by a period as the
   * suffix. So a list with a glyph type of UPPER_ALPHA and glyph format `%0.` at nesting level 0
   * will result in a list with rendered glyphs `A.` `B.` `C.` The glyph format can contain
   * placeholders for the current nesting level as well as placeholders for parent nesting levels.
   * For example, a list can have a glyph format of `%0.` at nesting level 0 and a glyph format of
   * `%0.%1.` at nesting level 1. Assuming both nesting levels have DECIMAL glyph types, this would
   * result in a list with rendered glyphs `1.` `2.` ` 2.1.` ` 2.2.` `3.` For nesting levels that
   * are ordered, the string that replaces a placeholder in the glyph format for a particular
   * paragraph depends on the paragraph's order within the list.
   * @return value or {@code null} for none
   */
  public java.lang.String getGlyphFormat() {
    return glyphFormat;
  }

  /**
   * The format string used by bullets at this level of nesting. The glyph format contains one or
   * more placeholders, and these placeholders are replaced with the appropriate values depending on
   * the glyph_type or glyph_symbol. The placeholders follow the pattern `%[nesting_level]`.
   * Furthermore, placeholders can have prefixes and suffixes. Thus, the glyph format follows the
   * pattern `%[nesting_level]`. Note that the prefix and suffix are optional and can be arbitrary
   * strings. For example, the glyph format `%0.` indicates that the rendered glyph will replace the
   * placeholder with the corresponding glyph for nesting level 0 followed by a period as the
   * suffix. So a list with a glyph type of UPPER_ALPHA and glyph format `%0.` at nesting level 0
   * will result in a list with rendered glyphs `A.` `B.` `C.` The glyph format can contain
   * placeholders for the current nesting level as well as placeholders for parent nesting levels.
   * For example, a list can have a glyph format of `%0.` at nesting level 0 and a glyph format of
   * `%0.%1.` at nesting level 1. Assuming both nesting levels have DECIMAL glyph types, this would
   * result in a list with rendered glyphs `1.` `2.` ` 2.1.` ` 2.2.` `3.` For nesting levels that
   * are ordered, the string that replaces a placeholder in the glyph format for a particular
   * paragraph depends on the paragraph's order within the list.
   * @param glyphFormat glyphFormat or {@code null} for none
   */
  public NestingLevel setGlyphFormat(java.lang.String glyphFormat) {
    this.glyphFormat = glyphFormat;
    return this;
  }

  /**
   * A custom glyph symbol used by bullets when paragraphs at this level of nesting is unordered.
   * The glyph symbol replaces placeholders within the glyph_format. For example, if the
   * glyph_symbol is the solid circle corresponding to Unicode U+25cf code point and the
   * glyph_format is `%0`, the rendered glyph would be the solid circle.
   * @return value or {@code null} for none
   */
  public java.lang.String getGlyphSymbol() {
    return glyphSymbol;
  }

  /**
   * A custom glyph symbol used by bullets when paragraphs at this level of nesting is unordered.
   * The glyph symbol replaces placeholders within the glyph_format. For example, if the
   * glyph_symbol is the solid circle corresponding to Unicode U+25cf code point and the
   * glyph_format is `%0`, the rendered glyph would be the solid circle.
   * @param glyphSymbol glyphSymbol or {@code null} for none
   */
  public NestingLevel setGlyphSymbol(java.lang.String glyphSymbol) {
    this.glyphSymbol = glyphSymbol;
    return this;
  }

  /**
   * The type of glyph used by bullets when paragraphs at this level of nesting is ordered. The
   * glyph type determines the type of glyph used to replace placeholders within the glyph_format
   * when paragraphs at this level of nesting are ordered. For example, if the nesting level is 0,
   * the glyph_format is `%0.` and the glyph type is DECIMAL, then the rendered glyph would replace
   * the placeholder `%0` in the glyph format with a number corresponding to the list item's order
   * within the list.
   * @return value or {@code null} for none
   */
  public java.lang.String getGlyphType() {
    return glyphType;
  }

  /**
   * The type of glyph used by bullets when paragraphs at this level of nesting is ordered. The
   * glyph type determines the type of glyph used to replace placeholders within the glyph_format
   * when paragraphs at this level of nesting are ordered. For example, if the nesting level is 0,
   * the glyph_format is `%0.` and the glyph type is DECIMAL, then the rendered glyph would replace
   * the placeholder `%0` in the glyph format with a number corresponding to the list item's order
   * within the list.
   * @param glyphType glyphType or {@code null} for none
   */
  public NestingLevel setGlyphType(java.lang.String glyphType) {
    this.glyphType = glyphType;
    return this;
  }

  /**
   * The amount of indentation for the first line of paragraphs at this level of nesting.
   * @return value or {@code null} for none
   */
  public Dimension getIndentFirstLine() {
    return indentFirstLine;
  }

  /**
   * The amount of indentation for the first line of paragraphs at this level of nesting.
   * @param indentFirstLine indentFirstLine or {@code null} for none
   */
  public NestingLevel setIndentFirstLine(Dimension indentFirstLine) {
    this.indentFirstLine = indentFirstLine;
    return this;
  }

  /**
   * The amount of indentation for paragraphs at this level of nesting. Applied to the side that
   * corresponds to the start of the text, based on the paragraph's content direction.
   * @return value or {@code null} for none
   */
  public Dimension getIndentStart() {
    return indentStart;
  }

  /**
   * The amount of indentation for paragraphs at this level of nesting. Applied to the side that
   * corresponds to the start of the text, based on the paragraph's content direction.
   * @param indentStart indentStart or {@code null} for none
   */
  public NestingLevel setIndentStart(Dimension indentStart) {
    this.indentStart = indentStart;
    return this;
  }

  /**
   * The number of the first list item at this nesting level. A value of 0 is treated as a value of
   * 1 for lettered lists and Roman numeral lists. For values of both 0 and 1, lettered and Roman
   * numeral lists will begin at `a` and `i` respectively. This value is ignored for nesting levels
   * with unordered glyphs.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartNumber() {
    return startNumber;
  }

  /**
   * The number of the first list item at this nesting level. A value of 0 is treated as a value of
   * 1 for lettered lists and Roman numeral lists. For values of both 0 and 1, lettered and Roman
   * numeral lists will begin at `a` and `i` respectively. This value is ignored for nesting levels
   * with unordered glyphs.
   * @param startNumber startNumber or {@code null} for none
   */
  public NestingLevel setStartNumber(java.lang.Integer startNumber) {
    this.startNumber = startNumber;
    return this;
  }

  /**
   * The text style of bullets at this level of nesting.
   * @return value or {@code null} for none
   */
  public TextStyle getTextStyle() {
    return textStyle;
  }

  /**
   * The text style of bullets at this level of nesting.
   * @param textStyle textStyle or {@code null} for none
   */
  public NestingLevel setTextStyle(TextStyle textStyle) {
    this.textStyle = textStyle;
    return this;
  }

  @Override
  public NestingLevel set(String fieldName, Object value) {
    return (NestingLevel) super.set(fieldName, value);
  }

  @Override
  public NestingLevel clone() {
    return (NestingLevel) super.clone();
  }

}
