/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A named style. Paragraphs in the document can inherit their TextStyle and ParagraphStyle from
 * this named style when they have the same named style type.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NamedStyle extends com.google.api.client.json.GenericJson {

  /**
   * The type of this named style.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String namedStyleType;

  /**
   * The paragraph style of this named style.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParagraphStyle paragraphStyle;

  /**
   * The text style of this named style.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextStyle textStyle;

  /**
   * The type of this named style.
   * @return value or {@code null} for none
   */
  public java.lang.String getNamedStyleType() {
    return namedStyleType;
  }

  /**
   * The type of this named style.
   * @param namedStyleType namedStyleType or {@code null} for none
   */
  public NamedStyle setNamedStyleType(java.lang.String namedStyleType) {
    this.namedStyleType = namedStyleType;
    return this;
  }

  /**
   * The paragraph style of this named style.
   * @return value or {@code null} for none
   */
  public ParagraphStyle getParagraphStyle() {
    return paragraphStyle;
  }

  /**
   * The paragraph style of this named style.
   * @param paragraphStyle paragraphStyle or {@code null} for none
   */
  public NamedStyle setParagraphStyle(ParagraphStyle paragraphStyle) {
    this.paragraphStyle = paragraphStyle;
    return this;
  }

  /**
   * The text style of this named style.
   * @return value or {@code null} for none
   */
  public TextStyle getTextStyle() {
    return textStyle;
  }

  /**
   * The text style of this named style.
   * @param textStyle textStyle or {@code null} for none
   */
  public NamedStyle setTextStyle(TextStyle textStyle) {
    this.textStyle = textStyle;
    return this;
  }

  @Override
  public NamedStyle set(String fieldName, Object value) {
    return (NamedStyle) super.set(fieldName, value);
  }

  @Override
  public NamedStyle clone() {
    return (NamedStyle) super.clone();
  }

}
