/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A collection of Ranges with the same named range ID. Named ranges allow developers to associate
 * parts of a document with an arbitrary user-defined label so their contents can be
 * programmatically read or edited later. A document can contain multiple named ranges with the same
 * name, but every named range has a unique ID. A named range is created with a single Range, and
 * content inserted inside a named range generally expands that range. However, certain document
 * changes can cause the range to be split into multiple ranges. Named ranges are not private. All
 * applications and collaborators that have access to the document can see its named ranges.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NamedRange extends com.google.api.client.json.GenericJson {

  /**
   * The name of the named range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The ID of the named range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String namedRangeId;

  /**
   * The ranges that belong to this named range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Range> ranges;

  /**
   * The name of the named range.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the named range.
   * @param name name or {@code null} for none
   */
  public NamedRange setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The ID of the named range.
   * @return value or {@code null} for none
   */
  public java.lang.String getNamedRangeId() {
    return namedRangeId;
  }

  /**
   * The ID of the named range.
   * @param namedRangeId namedRangeId or {@code null} for none
   */
  public NamedRange setNamedRangeId(java.lang.String namedRangeId) {
    this.namedRangeId = namedRangeId;
    return this;
  }

  /**
   * The ranges that belong to this named range.
   * @return value or {@code null} for none
   */
  public java.util.List<Range> getRanges() {
    return ranges;
  }

  /**
   * The ranges that belong to this named range.
   * @param ranges ranges or {@code null} for none
   */
  public NamedRange setRanges(java.util.List<Range> ranges) {
    this.ranges = ranges;
    return this;
  }

  @Override
  public NamedRange set(String fieldName, Object value) {
    return (NamedRange) super.set(fieldName, value);
  }

  @Override
  public NamedRange clone() {
    return (NamedRange) super.clone();
  }

}
