/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A List represents the list attributes for a group of paragraphs that all belong to the same list.
 * A paragraph that's part of a list has a reference to the list's ID in its bullet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class List extends com.google.api.client.json.GenericJson {

  /**
   * The properties of the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ListProperties listProperties;

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> suggestedDeletionIds;

  /**
   * The suggested insertion ID. If empty, then this is not a suggested insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String suggestedInsertionId;

  /**
   * The suggested changes to the list properties, keyed by suggestion ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, SuggestedListProperties> suggestedListPropertiesChanges;

  /**
   * The properties of the list.
   * @return value or {@code null} for none
   */
  public ListProperties getListProperties() {
    return listProperties;
  }

  /**
   * The properties of the list.
   * @param listProperties listProperties or {@code null} for none
   */
  public List setListProperties(ListProperties listProperties) {
    this.listProperties = listProperties;
    return this;
  }

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this list.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSuggestedDeletionIds() {
    return suggestedDeletionIds;
  }

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this list.
   * @param suggestedDeletionIds suggestedDeletionIds or {@code null} for none
   */
  public List setSuggestedDeletionIds(java.util.List<java.lang.String> suggestedDeletionIds) {
    this.suggestedDeletionIds = suggestedDeletionIds;
    return this;
  }

  /**
   * The suggested insertion ID. If empty, then this is not a suggested insertion.
   * @return value or {@code null} for none
   */
  public java.lang.String getSuggestedInsertionId() {
    return suggestedInsertionId;
  }

  /**
   * The suggested insertion ID. If empty, then this is not a suggested insertion.
   * @param suggestedInsertionId suggestedInsertionId or {@code null} for none
   */
  public List setSuggestedInsertionId(java.lang.String suggestedInsertionId) {
    this.suggestedInsertionId = suggestedInsertionId;
    return this;
  }

  /**
   * The suggested changes to the list properties, keyed by suggestion ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, SuggestedListProperties> getSuggestedListPropertiesChanges() {
    return suggestedListPropertiesChanges;
  }

  /**
   * The suggested changes to the list properties, keyed by suggestion ID.
   * @param suggestedListPropertiesChanges suggestedListPropertiesChanges or {@code null} for none
   */
  public List setSuggestedListPropertiesChanges(java.util.Map<String, SuggestedListProperties> suggestedListPropertiesChanges) {
    this.suggestedListPropertiesChanges = suggestedListPropertiesChanges;
    return this;
  }

  @Override
  public List set(String fieldName, Object value) {
    return (List) super.set(fieldName, value);
  }

  @Override
  public List clone() {
    return (List) super.clone();
  }

}
