/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A reference to another portion of a document or an external URL resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Link extends com.google.api.client.json.GenericJson {

  /**
   * A bookmark in this document. In documents containing a single tab, links to bookmarks within
   * the singular tab continue to return Link.bookmarkId when the includeTabsContent parameter is
   * set to `false` or unset. Otherwise, this field is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BookmarkLink bookmark;

  /**
   * The ID of a bookmark in this document. Legacy field: Instead, set includeTabsContent to `true`
   * and use Link.bookmark for read and write operations. This field is only returned when
   * includeTabsContent is set to `false` in documents containing a single tab and links to a
   * bookmark within the singular tab. Otherwise, Link.bookmark is returned. If this field is used
   * in a write request, the bookmark is considered to be from the tab ID specified in the request.
   * If a tab ID is not specified in the request, it is considered to be from the first tab in the
   * document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bookmarkId;

  /**
   * A heading in this document. In documents containing a single tab, links to headings within the
   * singular tab continue to return Link.headingId when the includeTabsContent parameter is set to
   * `false` or unset. Otherwise, this field is returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HeadingLink heading;

  /**
   * The ID of a heading in this document. Legacy field: Instead, set includeTabsContent to `true`
   * and use Link.heading for read and write operations. This field is only returned when
   * includeTabsContent is set to `false` in documents containing a single tab and links to a
   * heading within the singular tab. Otherwise, Link.heading is returned. If this field is used in
   * a write request, the heading is considered to be from the tab ID specified in the request. If a
   * tab ID is not specified in the request, it is considered to be from the first tab in the
   * document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String headingId;

  /**
   * The ID of a tab in this document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tabId;

  /**
   * An external URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * A bookmark in this document. In documents containing a single tab, links to bookmarks within
   * the singular tab continue to return Link.bookmarkId when the includeTabsContent parameter is
   * set to `false` or unset. Otherwise, this field is returned.
   * @return value or {@code null} for none
   */
  public BookmarkLink getBookmark() {
    return bookmark;
  }

  /**
   * A bookmark in this document. In documents containing a single tab, links to bookmarks within
   * the singular tab continue to return Link.bookmarkId when the includeTabsContent parameter is
   * set to `false` or unset. Otherwise, this field is returned.
   * @param bookmark bookmark or {@code null} for none
   */
  public Link setBookmark(BookmarkLink bookmark) {
    this.bookmark = bookmark;
    return this;
  }

  /**
   * The ID of a bookmark in this document. Legacy field: Instead, set includeTabsContent to `true`
   * and use Link.bookmark for read and write operations. This field is only returned when
   * includeTabsContent is set to `false` in documents containing a single tab and links to a
   * bookmark within the singular tab. Otherwise, Link.bookmark is returned. If this field is used
   * in a write request, the bookmark is considered to be from the tab ID specified in the request.
   * If a tab ID is not specified in the request, it is considered to be from the first tab in the
   * document.
   * @return value or {@code null} for none
   */
  public java.lang.String getBookmarkId() {
    return bookmarkId;
  }

  /**
   * The ID of a bookmark in this document. Legacy field: Instead, set includeTabsContent to `true`
   * and use Link.bookmark for read and write operations. This field is only returned when
   * includeTabsContent is set to `false` in documents containing a single tab and links to a
   * bookmark within the singular tab. Otherwise, Link.bookmark is returned. If this field is used
   * in a write request, the bookmark is considered to be from the tab ID specified in the request.
   * If a tab ID is not specified in the request, it is considered to be from the first tab in the
   * document.
   * @param bookmarkId bookmarkId or {@code null} for none
   */
  public Link setBookmarkId(java.lang.String bookmarkId) {
    this.bookmarkId = bookmarkId;
    return this;
  }

  /**
   * A heading in this document. In documents containing a single tab, links to headings within the
   * singular tab continue to return Link.headingId when the includeTabsContent parameter is set to
   * `false` or unset. Otherwise, this field is returned.
   * @return value or {@code null} for none
   */
  public HeadingLink getHeading() {
    return heading;
  }

  /**
   * A heading in this document. In documents containing a single tab, links to headings within the
   * singular tab continue to return Link.headingId when the includeTabsContent parameter is set to
   * `false` or unset. Otherwise, this field is returned.
   * @param heading heading or {@code null} for none
   */
  public Link setHeading(HeadingLink heading) {
    this.heading = heading;
    return this;
  }

  /**
   * The ID of a heading in this document. Legacy field: Instead, set includeTabsContent to `true`
   * and use Link.heading for read and write operations. This field is only returned when
   * includeTabsContent is set to `false` in documents containing a single tab and links to a
   * heading within the singular tab. Otherwise, Link.heading is returned. If this field is used in
   * a write request, the heading is considered to be from the tab ID specified in the request. If a
   * tab ID is not specified in the request, it is considered to be from the first tab in the
   * document.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeadingId() {
    return headingId;
  }

  /**
   * The ID of a heading in this document. Legacy field: Instead, set includeTabsContent to `true`
   * and use Link.heading for read and write operations. This field is only returned when
   * includeTabsContent is set to `false` in documents containing a single tab and links to a
   * heading within the singular tab. Otherwise, Link.heading is returned. If this field is used in
   * a write request, the heading is considered to be from the tab ID specified in the request. If a
   * tab ID is not specified in the request, it is considered to be from the first tab in the
   * document.
   * @param headingId headingId or {@code null} for none
   */
  public Link setHeadingId(java.lang.String headingId) {
    this.headingId = headingId;
    return this;
  }

  /**
   * The ID of a tab in this document.
   * @return value or {@code null} for none
   */
  public java.lang.String getTabId() {
    return tabId;
  }

  /**
   * The ID of a tab in this document.
   * @param tabId tabId or {@code null} for none
   */
  public Link setTabId(java.lang.String tabId) {
    this.tabId = tabId;
    return this;
  }

  /**
   * An external URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * An external URL.
   * @param url url or {@code null} for none
   */
  public Link setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public Link set(String fieldName, Object value) {
    return (Link) super.set(fieldName, value);
  }

  @Override
  public Link clone() {
    return (Link) super.clone();
  }

}
