/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Inserts text at the specified location.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InsertTextRequest extends com.google.api.client.json.GenericJson {

  /**
   * Inserts the text at the end of a header, footer, footnote or the document body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EndOfSegmentLocation endOfSegmentLocation;

  /**
   * Inserts the text at a specific index in the document. Text must be inserted inside the bounds
   * of an existing Paragraph. For instance, text cannot be inserted at a table's start index (i.e.
   * between the table and its preceding paragraph). The text must be inserted in the preceding
   * paragraph.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location location;

  /**
   * The text to be inserted. Inserting a newline character will implicitly create a new Paragraph
   * at that index. The paragraph style of the new paragraph will be copied from the paragraph at
   * the current insertion index, including lists and bullets. Text styles for inserted text will be
   * determined automatically, generally preserving the styling of neighboring text. In most cases,
   * the text style for the inserted text will match the text immediately before the insertion
   * index. Some control characters (U+0000-U+0008, U+000C-U+001F) and characters from the Unicode
   * Basic Multilingual Plane Private Use Area (U+E000-U+F8FF) will be stripped out of the inserted
   * text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * Inserts the text at the end of a header, footer, footnote or the document body.
   * @return value or {@code null} for none
   */
  public EndOfSegmentLocation getEndOfSegmentLocation() {
    return endOfSegmentLocation;
  }

  /**
   * Inserts the text at the end of a header, footer, footnote or the document body.
   * @param endOfSegmentLocation endOfSegmentLocation or {@code null} for none
   */
  public InsertTextRequest setEndOfSegmentLocation(EndOfSegmentLocation endOfSegmentLocation) {
    this.endOfSegmentLocation = endOfSegmentLocation;
    return this;
  }

  /**
   * Inserts the text at a specific index in the document. Text must be inserted inside the bounds
   * of an existing Paragraph. For instance, text cannot be inserted at a table's start index (i.e.
   * between the table and its preceding paragraph). The text must be inserted in the preceding
   * paragraph.
   * @return value or {@code null} for none
   */
  public Location getLocation() {
    return location;
  }

  /**
   * Inserts the text at a specific index in the document. Text must be inserted inside the bounds
   * of an existing Paragraph. For instance, text cannot be inserted at a table's start index (i.e.
   * between the table and its preceding paragraph). The text must be inserted in the preceding
   * paragraph.
   * @param location location or {@code null} for none
   */
  public InsertTextRequest setLocation(Location location) {
    this.location = location;
    return this;
  }

  /**
   * The text to be inserted. Inserting a newline character will implicitly create a new Paragraph
   * at that index. The paragraph style of the new paragraph will be copied from the paragraph at
   * the current insertion index, including lists and bullets. Text styles for inserted text will be
   * determined automatically, generally preserving the styling of neighboring text. In most cases,
   * the text style for the inserted text will match the text immediately before the insertion
   * index. Some control characters (U+0000-U+0008, U+000C-U+001F) and characters from the Unicode
   * Basic Multilingual Plane Private Use Area (U+E000-U+F8FF) will be stripped out of the inserted
   * text.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * The text to be inserted. Inserting a newline character will implicitly create a new Paragraph
   * at that index. The paragraph style of the new paragraph will be copied from the paragraph at
   * the current insertion index, including lists and bullets. Text styles for inserted text will be
   * determined automatically, generally preserving the styling of neighboring text. In most cases,
   * the text style for the inserted text will match the text immediately before the insertion
   * index. Some control characters (U+0000-U+0008, U+000C-U+001F) and characters from the Unicode
   * Basic Multilingual Plane Private Use Area (U+E000-U+F8FF) will be stripped out of the inserted
   * text.
   * @param text text or {@code null} for none
   */
  public InsertTextRequest setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  @Override
  public InsertTextRequest set(String fieldName, Object value) {
    return (InsertTextRequest) super.set(fieldName, value);
  }

  @Override
  public InsertTextRequest clone() {
    return (InsertTextRequest) super.clone();
  }

}
