/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * An object that appears inline with text. An InlineObject contains an EmbeddedObject such as an
 * image.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InlineObject extends com.google.api.client.json.GenericJson {

  /**
   * The properties of this inline object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InlineObjectProperties inlineObjectProperties;

  /**
   * The ID of this inline object. Can be used to update an object’s properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> suggestedDeletionIds;

  /**
   * The suggested changes to the inline object properties, keyed by suggestion ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, SuggestedInlineObjectProperties> suggestedInlineObjectPropertiesChanges;

  /**
   * The suggested insertion ID. If empty, then this is not a suggested insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String suggestedInsertionId;

  /**
   * The properties of this inline object.
   * @return value or {@code null} for none
   */
  public InlineObjectProperties getInlineObjectProperties() {
    return inlineObjectProperties;
  }

  /**
   * The properties of this inline object.
   * @param inlineObjectProperties inlineObjectProperties or {@code null} for none
   */
  public InlineObject setInlineObjectProperties(InlineObjectProperties inlineObjectProperties) {
    this.inlineObjectProperties = inlineObjectProperties;
    return this;
  }

  /**
   * The ID of this inline object. Can be used to update an object’s properties.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The ID of this inline object. Can be used to update an object’s properties.
   * @param objectId objectId or {@code null} for none
   */
  public InlineObject setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSuggestedDeletionIds() {
    return suggestedDeletionIds;
  }

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * @param suggestedDeletionIds suggestedDeletionIds or {@code null} for none
   */
  public InlineObject setSuggestedDeletionIds(java.util.List<java.lang.String> suggestedDeletionIds) {
    this.suggestedDeletionIds = suggestedDeletionIds;
    return this;
  }

  /**
   * The suggested changes to the inline object properties, keyed by suggestion ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, SuggestedInlineObjectProperties> getSuggestedInlineObjectPropertiesChanges() {
    return suggestedInlineObjectPropertiesChanges;
  }

  /**
   * The suggested changes to the inline object properties, keyed by suggestion ID.
   * @param suggestedInlineObjectPropertiesChanges suggestedInlineObjectPropertiesChanges or {@code null} for none
   */
  public InlineObject setSuggestedInlineObjectPropertiesChanges(java.util.Map<String, SuggestedInlineObjectProperties> suggestedInlineObjectPropertiesChanges) {
    this.suggestedInlineObjectPropertiesChanges = suggestedInlineObjectPropertiesChanges;
    return this;
  }

  /**
   * The suggested insertion ID. If empty, then this is not a suggested insertion.
   * @return value or {@code null} for none
   */
  public java.lang.String getSuggestedInsertionId() {
    return suggestedInsertionId;
  }

  /**
   * The suggested insertion ID. If empty, then this is not a suggested insertion.
   * @param suggestedInsertionId suggestedInsertionId or {@code null} for none
   */
  public InlineObject setSuggestedInsertionId(java.lang.String suggestedInsertionId) {
    this.suggestedInsertionId = suggestedInsertionId;
    return this;
  }

  @Override
  public InlineObject set(String fieldName, Object value) {
    return (InlineObject) super.set(fieldName, value);
  }

  @Override
  public InlineObject clone() {
    return (InlineObject) super.clone();
  }

}
