/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * The properties of an image.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ImageProperties extends com.google.api.client.json.GenericJson {

  /**
   * The clockwise rotation angle of the image, in radians.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float angle;

  /**
   * The brightness effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float brightness;

  /**
   * A URI to the image with a default lifetime of 30 minutes. This URI is tagged with the account
   * of the requester. Anyone with the URI effectively accesses the image as the original requester.
   * Access to the image may be lost if the document's sharing settings change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentUri;

  /**
   * The contrast effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float contrast;

  /**
   * The crop properties of the image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CropProperties cropProperties;

  /**
   * The source URI is the URI used to insert the image. The source URI can be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceUri;

  /**
   * The transparency effect of the image. The value should be in the interval [0.0, 1.0], where 0
   * means no effect and 1 means transparent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float transparency;

  /**
   * The clockwise rotation angle of the image, in radians.
   * @return value or {@code null} for none
   */
  public java.lang.Float getAngle() {
    return angle;
  }

  /**
   * The clockwise rotation angle of the image, in radians.
   * @param angle angle or {@code null} for none
   */
  public ImageProperties setAngle(java.lang.Float angle) {
    this.angle = angle;
    return this;
  }

  /**
   * The brightness effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect.
   * @return value or {@code null} for none
   */
  public java.lang.Float getBrightness() {
    return brightness;
  }

  /**
   * The brightness effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect.
   * @param brightness brightness or {@code null} for none
   */
  public ImageProperties setBrightness(java.lang.Float brightness) {
    this.brightness = brightness;
    return this;
  }

  /**
   * A URI to the image with a default lifetime of 30 minutes. This URI is tagged with the account
   * of the requester. Anyone with the URI effectively accesses the image as the original requester.
   * Access to the image may be lost if the document's sharing settings change.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentUri() {
    return contentUri;
  }

  /**
   * A URI to the image with a default lifetime of 30 minutes. This URI is tagged with the account
   * of the requester. Anyone with the URI effectively accesses the image as the original requester.
   * Access to the image may be lost if the document's sharing settings change.
   * @param contentUri contentUri or {@code null} for none
   */
  public ImageProperties setContentUri(java.lang.String contentUri) {
    this.contentUri = contentUri;
    return this;
  }

  /**
   * The contrast effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect.
   * @return value or {@code null} for none
   */
  public java.lang.Float getContrast() {
    return contrast;
  }

  /**
   * The contrast effect of the image. The value should be in the interval [-1.0, 1.0], where 0
   * means no effect.
   * @param contrast contrast or {@code null} for none
   */
  public ImageProperties setContrast(java.lang.Float contrast) {
    this.contrast = contrast;
    return this;
  }

  /**
   * The crop properties of the image.
   * @return value or {@code null} for none
   */
  public CropProperties getCropProperties() {
    return cropProperties;
  }

  /**
   * The crop properties of the image.
   * @param cropProperties cropProperties or {@code null} for none
   */
  public ImageProperties setCropProperties(CropProperties cropProperties) {
    this.cropProperties = cropProperties;
    return this;
  }

  /**
   * The source URI is the URI used to insert the image. The source URI can be empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceUri() {
    return sourceUri;
  }

  /**
   * The source URI is the URI used to insert the image. The source URI can be empty.
   * @param sourceUri sourceUri or {@code null} for none
   */
  public ImageProperties setSourceUri(java.lang.String sourceUri) {
    this.sourceUri = sourceUri;
    return this;
  }

  /**
   * The transparency effect of the image. The value should be in the interval [0.0, 1.0], where 0
   * means no effect and 1 means transparent.
   * @return value or {@code null} for none
   */
  public java.lang.Float getTransparency() {
    return transparency;
  }

  /**
   * The transparency effect of the image. The value should be in the interval [0.0, 1.0], where 0
   * means no effect and 1 means transparent.
   * @param transparency transparency or {@code null} for none
   */
  public ImageProperties setTransparency(java.lang.Float transparency) {
    this.transparency = transparency;
    return this;
  }

  @Override
  public ImageProperties set(String fieldName, Object value) {
    return (ImageProperties) super.set(fieldName, value);
  }

  @Override
  public ImageProperties clone() {
    return (ImageProperties) super.clone();
  }

}
