/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A reference to a heading in this document.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HeadingLink extends com.google.api.client.json.GenericJson {

  /**
   * The ID of a heading in this document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The ID of the tab containing this heading.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tabId;

  /**
   * The ID of a heading in this document.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of a heading in this document.
   * @param id id or {@code null} for none
   */
  public HeadingLink setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The ID of the tab containing this heading.
   * @return value or {@code null} for none
   */
  public java.lang.String getTabId() {
    return tabId;
  }

  /**
   * The ID of the tab containing this heading.
   * @param tabId tabId or {@code null} for none
   */
  public HeadingLink setTabId(java.lang.String tabId) {
    this.tabId = tabId;
    return this;
  }

  @Override
  public HeadingLink set(String fieldName, Object value) {
    return (HeadingLink) super.set(fieldName, value);
  }

  @Override
  public HeadingLink clone() {
    return (HeadingLink) super.clone();
  }

}
