/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A mask that indicates which of the fields on the base EmbeddedObject have been changed in this
 * suggestion. For any field set to true, there's a new suggested value.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EmbeddedObjectSuggestionState extends com.google.api.client.json.GenericJson {

  /**
   * Indicates if there was a suggested change to description.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean descriptionSuggested;

  /**
   * A mask that indicates which of the fields in embedded_drawing_properties have been changed in
   * this suggestion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmbeddedDrawingPropertiesSuggestionState embeddedDrawingPropertiesSuggestionState;

  /**
   * A mask that indicates which of the fields in embedded_object_border have been changed in this
   * suggestion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmbeddedObjectBorderSuggestionState embeddedObjectBorderSuggestionState;

  /**
   * A mask that indicates which of the fields in image_properties have been changed in this
   * suggestion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ImagePropertiesSuggestionState imagePropertiesSuggestionState;

  /**
   * A mask that indicates which of the fields in linked_content_reference have been changed in this
   * suggestion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinkedContentReferenceSuggestionState linkedContentReferenceSuggestionState;

  /**
   * Indicates if there was a suggested change to margin_bottom.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean marginBottomSuggested;

  /**
   * Indicates if there was a suggested change to margin_left.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean marginLeftSuggested;

  /**
   * Indicates if there was a suggested change to margin_right.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean marginRightSuggested;

  /**
   * Indicates if there was a suggested change to margin_top.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean marginTopSuggested;

  /**
   * A mask that indicates which of the fields in size have been changed in this suggestion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SizeSuggestionState sizeSuggestionState;

  /**
   * Indicates if there was a suggested change to title.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean titleSuggested;

  /**
   * Indicates if there was a suggested change to description.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDescriptionSuggested() {
    return descriptionSuggested;
  }

  /**
   * Indicates if there was a suggested change to description.
   * @param descriptionSuggested descriptionSuggested or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setDescriptionSuggested(java.lang.Boolean descriptionSuggested) {
    this.descriptionSuggested = descriptionSuggested;
    return this;
  }

  /**
   * A mask that indicates which of the fields in embedded_drawing_properties have been changed in
   * this suggestion.
   * @return value or {@code null} for none
   */
  public EmbeddedDrawingPropertiesSuggestionState getEmbeddedDrawingPropertiesSuggestionState() {
    return embeddedDrawingPropertiesSuggestionState;
  }

  /**
   * A mask that indicates which of the fields in embedded_drawing_properties have been changed in
   * this suggestion.
   * @param embeddedDrawingPropertiesSuggestionState embeddedDrawingPropertiesSuggestionState or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setEmbeddedDrawingPropertiesSuggestionState(EmbeddedDrawingPropertiesSuggestionState embeddedDrawingPropertiesSuggestionState) {
    this.embeddedDrawingPropertiesSuggestionState = embeddedDrawingPropertiesSuggestionState;
    return this;
  }

  /**
   * A mask that indicates which of the fields in embedded_object_border have been changed in this
   * suggestion.
   * @return value or {@code null} for none
   */
  public EmbeddedObjectBorderSuggestionState getEmbeddedObjectBorderSuggestionState() {
    return embeddedObjectBorderSuggestionState;
  }

  /**
   * A mask that indicates which of the fields in embedded_object_border have been changed in this
   * suggestion.
   * @param embeddedObjectBorderSuggestionState embeddedObjectBorderSuggestionState or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setEmbeddedObjectBorderSuggestionState(EmbeddedObjectBorderSuggestionState embeddedObjectBorderSuggestionState) {
    this.embeddedObjectBorderSuggestionState = embeddedObjectBorderSuggestionState;
    return this;
  }

  /**
   * A mask that indicates which of the fields in image_properties have been changed in this
   * suggestion.
   * @return value or {@code null} for none
   */
  public ImagePropertiesSuggestionState getImagePropertiesSuggestionState() {
    return imagePropertiesSuggestionState;
  }

  /**
   * A mask that indicates which of the fields in image_properties have been changed in this
   * suggestion.
   * @param imagePropertiesSuggestionState imagePropertiesSuggestionState or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setImagePropertiesSuggestionState(ImagePropertiesSuggestionState imagePropertiesSuggestionState) {
    this.imagePropertiesSuggestionState = imagePropertiesSuggestionState;
    return this;
  }

  /**
   * A mask that indicates which of the fields in linked_content_reference have been changed in this
   * suggestion.
   * @return value or {@code null} for none
   */
  public LinkedContentReferenceSuggestionState getLinkedContentReferenceSuggestionState() {
    return linkedContentReferenceSuggestionState;
  }

  /**
   * A mask that indicates which of the fields in linked_content_reference have been changed in this
   * suggestion.
   * @param linkedContentReferenceSuggestionState linkedContentReferenceSuggestionState or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setLinkedContentReferenceSuggestionState(LinkedContentReferenceSuggestionState linkedContentReferenceSuggestionState) {
    this.linkedContentReferenceSuggestionState = linkedContentReferenceSuggestionState;
    return this;
  }

  /**
   * Indicates if there was a suggested change to margin_bottom.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMarginBottomSuggested() {
    return marginBottomSuggested;
  }

  /**
   * Indicates if there was a suggested change to margin_bottom.
   * @param marginBottomSuggested marginBottomSuggested or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setMarginBottomSuggested(java.lang.Boolean marginBottomSuggested) {
    this.marginBottomSuggested = marginBottomSuggested;
    return this;
  }

  /**
   * Indicates if there was a suggested change to margin_left.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMarginLeftSuggested() {
    return marginLeftSuggested;
  }

  /**
   * Indicates if there was a suggested change to margin_left.
   * @param marginLeftSuggested marginLeftSuggested or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setMarginLeftSuggested(java.lang.Boolean marginLeftSuggested) {
    this.marginLeftSuggested = marginLeftSuggested;
    return this;
  }

  /**
   * Indicates if there was a suggested change to margin_right.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMarginRightSuggested() {
    return marginRightSuggested;
  }

  /**
   * Indicates if there was a suggested change to margin_right.
   * @param marginRightSuggested marginRightSuggested or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setMarginRightSuggested(java.lang.Boolean marginRightSuggested) {
    this.marginRightSuggested = marginRightSuggested;
    return this;
  }

  /**
   * Indicates if there was a suggested change to margin_top.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMarginTopSuggested() {
    return marginTopSuggested;
  }

  /**
   * Indicates if there was a suggested change to margin_top.
   * @param marginTopSuggested marginTopSuggested or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setMarginTopSuggested(java.lang.Boolean marginTopSuggested) {
    this.marginTopSuggested = marginTopSuggested;
    return this;
  }

  /**
   * A mask that indicates which of the fields in size have been changed in this suggestion.
   * @return value or {@code null} for none
   */
  public SizeSuggestionState getSizeSuggestionState() {
    return sizeSuggestionState;
  }

  /**
   * A mask that indicates which of the fields in size have been changed in this suggestion.
   * @param sizeSuggestionState sizeSuggestionState or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setSizeSuggestionState(SizeSuggestionState sizeSuggestionState) {
    this.sizeSuggestionState = sizeSuggestionState;
    return this;
  }

  /**
   * Indicates if there was a suggested change to title.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTitleSuggested() {
    return titleSuggested;
  }

  /**
   * Indicates if there was a suggested change to title.
   * @param titleSuggested titleSuggested or {@code null} for none
   */
  public EmbeddedObjectSuggestionState setTitleSuggested(java.lang.Boolean titleSuggested) {
    this.titleSuggested = titleSuggested;
    return this;
  }

  @Override
  public EmbeddedObjectSuggestionState set(String fieldName, Object value) {
    return (EmbeddedObjectSuggestionState) super.set(fieldName, value);
  }

  @Override
  public EmbeddedObjectSuggestionState clone() {
    return (EmbeddedObjectSuggestionState) super.clone();
  }

}
