/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A tab with document contents.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DocumentTab extends com.google.api.client.json.GenericJson {

  /**
   * The main body of the document tab.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Body body;

  /**
   * The style of the document tab.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DocumentStyle documentStyle;

  /**
   * The footers in the document tab, keyed by footer ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, Footer> footers;

  /**
   * The footnotes in the document tab, keyed by footnote ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, Footnote> footnotes;

  /**
   * The headers in the document tab, keyed by header ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, Header> headers;

  /**
   * The inline objects in the document tab, keyed by object ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, InlineObject> inlineObjects;

  /**
   * The lists in the document tab, keyed by list ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, List> lists;

  /**
   * The named ranges in the document tab, keyed by name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, NamedRanges> namedRanges;

  /**
   * The named styles of the document tab.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NamedStyles namedStyles;

  /**
   * The positioned objects in the document tab, keyed by object ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, PositionedObject> positionedObjects;

  /**
   * The suggested changes to the style of the document tab, keyed by suggestion ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, SuggestedDocumentStyle> suggestedDocumentStyleChanges;

  /**
   * The suggested changes to the named styles of the document tab, keyed by suggestion ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, SuggestedNamedStyles> suggestedNamedStylesChanges;

  /**
   * The main body of the document tab.
   * @return value or {@code null} for none
   */
  public Body getBody() {
    return body;
  }

  /**
   * The main body of the document tab.
   * @param body body or {@code null} for none
   */
  public DocumentTab setBody(Body body) {
    this.body = body;
    return this;
  }

  /**
   * The style of the document tab.
   * @return value or {@code null} for none
   */
  public DocumentStyle getDocumentStyle() {
    return documentStyle;
  }

  /**
   * The style of the document tab.
   * @param documentStyle documentStyle or {@code null} for none
   */
  public DocumentTab setDocumentStyle(DocumentStyle documentStyle) {
    this.documentStyle = documentStyle;
    return this;
  }

  /**
   * The footers in the document tab, keyed by footer ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, Footer> getFooters() {
    return footers;
  }

  /**
   * The footers in the document tab, keyed by footer ID.
   * @param footers footers or {@code null} for none
   */
  public DocumentTab setFooters(java.util.Map<String, Footer> footers) {
    this.footers = footers;
    return this;
  }

  /**
   * The footnotes in the document tab, keyed by footnote ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, Footnote> getFootnotes() {
    return footnotes;
  }

  /**
   * The footnotes in the document tab, keyed by footnote ID.
   * @param footnotes footnotes or {@code null} for none
   */
  public DocumentTab setFootnotes(java.util.Map<String, Footnote> footnotes) {
    this.footnotes = footnotes;
    return this;
  }

  /**
   * The headers in the document tab, keyed by header ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, Header> getHeaders() {
    return headers;
  }

  /**
   * The headers in the document tab, keyed by header ID.
   * @param headers headers or {@code null} for none
   */
  public DocumentTab setHeaders(java.util.Map<String, Header> headers) {
    this.headers = headers;
    return this;
  }

  /**
   * The inline objects in the document tab, keyed by object ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, InlineObject> getInlineObjects() {
    return inlineObjects;
  }

  /**
   * The inline objects in the document tab, keyed by object ID.
   * @param inlineObjects inlineObjects or {@code null} for none
   */
  public DocumentTab setInlineObjects(java.util.Map<String, InlineObject> inlineObjects) {
    this.inlineObjects = inlineObjects;
    return this;
  }

  /**
   * The lists in the document tab, keyed by list ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, List> getLists() {
    return lists;
  }

  /**
   * The lists in the document tab, keyed by list ID.
   * @param lists lists or {@code null} for none
   */
  public DocumentTab setLists(java.util.Map<String, List> lists) {
    this.lists = lists;
    return this;
  }

  /**
   * The named ranges in the document tab, keyed by name.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, NamedRanges> getNamedRanges() {
    return namedRanges;
  }

  /**
   * The named ranges in the document tab, keyed by name.
   * @param namedRanges namedRanges or {@code null} for none
   */
  public DocumentTab setNamedRanges(java.util.Map<String, NamedRanges> namedRanges) {
    this.namedRanges = namedRanges;
    return this;
  }

  /**
   * The named styles of the document tab.
   * @return value or {@code null} for none
   */
  public NamedStyles getNamedStyles() {
    return namedStyles;
  }

  /**
   * The named styles of the document tab.
   * @param namedStyles namedStyles or {@code null} for none
   */
  public DocumentTab setNamedStyles(NamedStyles namedStyles) {
    this.namedStyles = namedStyles;
    return this;
  }

  /**
   * The positioned objects in the document tab, keyed by object ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, PositionedObject> getPositionedObjects() {
    return positionedObjects;
  }

  /**
   * The positioned objects in the document tab, keyed by object ID.
   * @param positionedObjects positionedObjects or {@code null} for none
   */
  public DocumentTab setPositionedObjects(java.util.Map<String, PositionedObject> positionedObjects) {
    this.positionedObjects = positionedObjects;
    return this;
  }

  /**
   * The suggested changes to the style of the document tab, keyed by suggestion ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, SuggestedDocumentStyle> getSuggestedDocumentStyleChanges() {
    return suggestedDocumentStyleChanges;
  }

  /**
   * The suggested changes to the style of the document tab, keyed by suggestion ID.
   * @param suggestedDocumentStyleChanges suggestedDocumentStyleChanges or {@code null} for none
   */
  public DocumentTab setSuggestedDocumentStyleChanges(java.util.Map<String, SuggestedDocumentStyle> suggestedDocumentStyleChanges) {
    this.suggestedDocumentStyleChanges = suggestedDocumentStyleChanges;
    return this;
  }

  /**
   * The suggested changes to the named styles of the document tab, keyed by suggestion ID.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, SuggestedNamedStyles> getSuggestedNamedStylesChanges() {
    return suggestedNamedStylesChanges;
  }

  /**
   * The suggested changes to the named styles of the document tab, keyed by suggestion ID.
   * @param suggestedNamedStylesChanges suggestedNamedStylesChanges or {@code null} for none
   */
  public DocumentTab setSuggestedNamedStylesChanges(java.util.Map<String, SuggestedNamedStyles> suggestedNamedStylesChanges) {
    this.suggestedNamedStylesChanges = suggestedNamedStylesChanges;
    return this;
  }

  @Override
  public DocumentTab set(String fieldName, Object value) {
    return (DocumentTab) super.set(fieldName, value);
  }

  @Override
  public DocumentTab clone() {
    return (DocumentTab) super.clone();
  }

}
