/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Deletes content from the document.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeleteContentRangeRequest extends com.google.api.client.json.GenericJson {

  /**
   * The range of content to delete. Deleting text that crosses a paragraph boundary may result in
   * changes to paragraph styles, lists, positioned objects and bookmarks as the two paragraphs are
   * merged. Attempting to delete certain ranges can result in an invalid document structure in
   * which case a 400 bad request error is returned. Some examples of invalid delete requests
   * include: * Deleting one code unit of a surrogate pair. * Deleting the last newline character of
   * a Body, Header, Footer, Footnote, TableCell or TableOfContents. * Deleting the start or end of
   * a Table, TableOfContents or Equation without deleting the entire element. * Deleting the
   * newline character before a Table, TableOfContents or SectionBreak without deleting the element.
   * * Deleting individual rows or cells of a table. Deleting the content within a table cell is
   * allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Range range;

  /**
   * The range of content to delete. Deleting text that crosses a paragraph boundary may result in
   * changes to paragraph styles, lists, positioned objects and bookmarks as the two paragraphs are
   * merged. Attempting to delete certain ranges can result in an invalid document structure in
   * which case a 400 bad request error is returned. Some examples of invalid delete requests
   * include: * Deleting one code unit of a surrogate pair. * Deleting the last newline character of
   * a Body, Header, Footer, Footnote, TableCell or TableOfContents. * Deleting the start or end of
   * a Table, TableOfContents or Equation without deleting the entire element. * Deleting the
   * newline character before a Table, TableOfContents or SectionBreak without deleting the element.
   * * Deleting individual rows or cells of a table. Deleting the content within a table cell is
   * allowed.
   * @return value or {@code null} for none
   */
  public Range getRange() {
    return range;
  }

  /**
   * The range of content to delete. Deleting text that crosses a paragraph boundary may result in
   * changes to paragraph styles, lists, positioned objects and bookmarks as the two paragraphs are
   * merged. Attempting to delete certain ranges can result in an invalid document structure in
   * which case a 400 bad request error is returned. Some examples of invalid delete requests
   * include: * Deleting one code unit of a surrogate pair. * Deleting the last newline character of
   * a Body, Header, Footer, Footnote, TableCell or TableOfContents. * Deleting the start or end of
   * a Table, TableOfContents or Equation without deleting the entire element. * Deleting the
   * newline character before a Table, TableOfContents or SectionBreak without deleting the element.
   * * Deleting individual rows or cells of a table. Deleting the content within a table cell is
   * allowed.
   * @param range range or {@code null} for none
   */
  public DeleteContentRangeRequest setRange(Range range) {
    this.range = range;
    return this;
  }

  @Override
  public DeleteContentRangeRequest set(String fieldName, Object value) {
    return (DeleteContentRangeRequest) super.set(fieldName, value);
  }

  @Override
  public DeleteContentRangeRequest clone() {
    return (DeleteContentRangeRequest) super.clone();
  }

}
