/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * The crop properties of an image. The crop rectangle is represented using fractional offsets from
 * the original content's 4 edges. - If the offset is in the interval (0, 1), the corresponding edge
 * of crop rectangle is positioned inside of the image's original bounding rectangle. - If the
 * offset is negative or greater than 1, the corresponding edge of crop rectangle is positioned
 * outside of the image's original bounding rectangle. - If all offsets and rotation angles are 0,
 * the image is not cropped.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CropProperties extends com.google.api.client.json.GenericJson {

  /**
   * The clockwise rotation angle of the crop rectangle around its center, in radians. Rotation is
   * applied after the offsets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float angle;

  /**
   * The offset specifies how far inwards the bottom edge of the crop rectangle is from the bottom
   * edge of the original content as a fraction of the original content's height.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float offsetBottom;

  /**
   * The offset specifies how far inwards the left edge of the crop rectangle is from the left edge
   * of the original content as a fraction of the original content's width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float offsetLeft;

  /**
   * The offset specifies how far inwards the right edge of the crop rectangle is from the right
   * edge of the original content as a fraction of the original content's width.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float offsetRight;

  /**
   * The offset specifies how far inwards the top edge of the crop rectangle is from the top edge of
   * the original content as a fraction of the original content's height.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float offsetTop;

  /**
   * The clockwise rotation angle of the crop rectangle around its center, in radians. Rotation is
   * applied after the offsets.
   * @return value or {@code null} for none
   */
  public java.lang.Float getAngle() {
    return angle;
  }

  /**
   * The clockwise rotation angle of the crop rectangle around its center, in radians. Rotation is
   * applied after the offsets.
   * @param angle angle or {@code null} for none
   */
  public CropProperties setAngle(java.lang.Float angle) {
    this.angle = angle;
    return this;
  }

  /**
   * The offset specifies how far inwards the bottom edge of the crop rectangle is from the bottom
   * edge of the original content as a fraction of the original content's height.
   * @return value or {@code null} for none
   */
  public java.lang.Float getOffsetBottom() {
    return offsetBottom;
  }

  /**
   * The offset specifies how far inwards the bottom edge of the crop rectangle is from the bottom
   * edge of the original content as a fraction of the original content's height.
   * @param offsetBottom offsetBottom or {@code null} for none
   */
  public CropProperties setOffsetBottom(java.lang.Float offsetBottom) {
    this.offsetBottom = offsetBottom;
    return this;
  }

  /**
   * The offset specifies how far inwards the left edge of the crop rectangle is from the left edge
   * of the original content as a fraction of the original content's width.
   * @return value or {@code null} for none
   */
  public java.lang.Float getOffsetLeft() {
    return offsetLeft;
  }

  /**
   * The offset specifies how far inwards the left edge of the crop rectangle is from the left edge
   * of the original content as a fraction of the original content's width.
   * @param offsetLeft offsetLeft or {@code null} for none
   */
  public CropProperties setOffsetLeft(java.lang.Float offsetLeft) {
    this.offsetLeft = offsetLeft;
    return this;
  }

  /**
   * The offset specifies how far inwards the right edge of the crop rectangle is from the right
   * edge of the original content as a fraction of the original content's width.
   * @return value or {@code null} for none
   */
  public java.lang.Float getOffsetRight() {
    return offsetRight;
  }

  /**
   * The offset specifies how far inwards the right edge of the crop rectangle is from the right
   * edge of the original content as a fraction of the original content's width.
   * @param offsetRight offsetRight or {@code null} for none
   */
  public CropProperties setOffsetRight(java.lang.Float offsetRight) {
    this.offsetRight = offsetRight;
    return this;
  }

  /**
   * The offset specifies how far inwards the top edge of the crop rectangle is from the top edge of
   * the original content as a fraction of the original content's height.
   * @return value or {@code null} for none
   */
  public java.lang.Float getOffsetTop() {
    return offsetTop;
  }

  /**
   * The offset specifies how far inwards the top edge of the crop rectangle is from the top edge of
   * the original content as a fraction of the original content's height.
   * @param offsetTop offsetTop or {@code null} for none
   */
  public CropProperties setOffsetTop(java.lang.Float offsetTop) {
    this.offsetTop = offsetTop;
    return this;
  }

  @Override
  public CropProperties set(String fieldName, Object value) {
    return (CropProperties) super.set(fieldName, value);
  }

  @Override
  public CropProperties clone() {
    return (CropProperties) super.clone();
  }

}
