/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Creates a NamedRange referencing the given range.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateNamedRangeRequest extends com.google.api.client.json.GenericJson {

  /**
   * The name of the NamedRange. Names do not need to be unique. Names must be at least 1 character
   * and no more than 256 characters, measured in UTF-16 code units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The range to apply the name to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Range range;

  /**
   * The name of the NamedRange. Names do not need to be unique. Names must be at least 1 character
   * and no more than 256 characters, measured in UTF-16 code units.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the NamedRange. Names do not need to be unique. Names must be at least 1 character
   * and no more than 256 characters, measured in UTF-16 code units.
   * @param name name or {@code null} for none
   */
  public CreateNamedRangeRequest setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The range to apply the name to.
   * @return value or {@code null} for none
   */
  public Range getRange() {
    return range;
  }

  /**
   * The range to apply the name to.
   * @param range range or {@code null} for none
   */
  public CreateNamedRangeRequest setRange(Range range) {
    this.range = range;
    return this;
  }

  @Override
  public CreateNamedRangeRequest set(String fieldName, Object value) {
    return (CreateNamedRangeRequest) super.set(fieldName, value);
  }

  @Override
  public CreateNamedRangeRequest clone() {
    return (CreateNamedRangeRequest) super.clone();
  }

}
