/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * WorkerHealthReportResponse contains information returned to the worker in response to a health
 * ping.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WorkerHealthReportResponse extends com.google.api.client.json.GenericJson {

  /**
   * A positive value indicates the worker should change its reporting interval to the specified
   * value. The default value of zero means no change in report rate is requested by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String reportInterval;

  /**
   * A positive value indicates the worker should change its reporting interval to the specified
   * value. The default value of zero means no change in report rate is requested by the server.
   * @return value or {@code null} for none
   */
  public String getReportInterval() {
    return reportInterval;
  }

  /**
   * A positive value indicates the worker should change its reporting interval to the specified
   * value. The default value of zero means no change in report rate is requested by the server.
   * @param reportInterval reportInterval or {@code null} for none
   */
  public WorkerHealthReportResponse setReportInterval(String reportInterval) {
    this.reportInterval = reportInterval;
    return this;
  }

  @Override
  public WorkerHealthReportResponse set(String fieldName, Object value) {
    return (WorkerHealthReportResponse) super.set(fieldName, value);
  }

  @Override
  public WorkerHealthReportResponse clone() {
    return (WorkerHealthReportResponse) super.clone();
  }

}
